---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-プロファイラー設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/settings.html.twig` 全体（317行）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` 63行目（インクルード）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/base.html.twig` 27-44行目（初期化スクリプト）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 11行目（画面No.10）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 28-29行目
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 32行目（PANEL→SETTINGSの遷移）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | layout.html.twigの63行目でインクルードされる | E-02 | ○ |
| C-02 | 独立したルートやコントローラーを持たない | E-04 (備考「レイアウト内インクルード」) | ○ |
| C-03 | テーマ設定はauto/light/darkの3択 | E-01 (210-231行目) | ○ |
| C-04 | ページ幅設定はnormal/fullの2択 | E-01 (237-251行目) | ○ |
| C-05 | localStorageキー`symfony/profiler/theme`に保存される | E-01 (264行目), E-03 (28行目) | ○ |
| C-06 | localStorageキー`symfony/profiler/width`に保存される | E-01 (264行目), E-03 (39行目) | ○ |
| C-07 | デフォルトテーマはtheme-auto | E-01 (296行目), E-03 (28行目) | ○ |
| C-08 | デフォルトページ幅はwidth-normal | E-01 (297行目), E-03 (39行目) | ○ |
| C-09 | autoモード時にmatchMediaでOS設定を検出する | E-01 (275-276行目), E-03 (29-34行目) | ○ |
| C-10 | document.bodyのCSSクラスを即時更新する | E-01 (269-278行目) | ○ |
| C-11 | document.body.style.colorSchemeを設定する | E-01 (280-282行目) | ○ |
| C-12 | モーダルヘッダーに"Configuration Settings"と表示される | E-01 (201行目) | ○ |
| C-13 | 閉じるボタンでモーダルを閉じられる | E-01 (304行目) | ○ |
| C-14 | 背景クリックでモーダルを閉じられる | E-01 (305-308行目) | ○ |
| C-15 | Escキーでモーダルを閉じられる | E-01 (310-313行目) | ○ |
| C-16 | モーダル表示時に閉じるボタンにフォーカスが移動する | E-01 (300行目) | ○ |
| C-17 | モーダル閉じた時に設定リンクにフォーカスが戻る | E-01 (292行目) | ○ |
| C-18 | CSS変数で:rootと.theme-darkのテーマカラーが定義される | E-01 (2-27行目) | ○ |
| C-19 | モーダルのトランジションは0.3秒ease-in-out | E-01 (44-46行目, 58-60行目) | ○ |
| C-20 | backdrop-filter: blur(2px)が適用される | E-01 (50行目) | ○ |
| C-21 | ラジオボタンのinput要素はCSSで視覚的に非表示 | E-01 (130-134行目) | ○ |
| C-22 | 768px以下でリンクテキストが非表示になる | E-01 (183-190行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がsettings.html.twig、layout.html.twig、base.html.twigのソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クライアントサイドのみの動作で、サーバーサイドへの影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] settings.html.twigのHTML構造（ラジオボタンのID、name、value）が設計書と一致しているか確認
- [ ] JavaScriptのlocalStorage操作（キー名、値のフォーマット）が正確か確認
- [ ] base.html.twigの初期化スクリプトが設計書の記述と一致しているか確認
- [ ] モーダルの開閉操作（クリック、Esc、背景クリック）が全て実装されているか確認
