---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：11-リダイレクトインターセプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **AutoExpireFlashBag延長動作の詳細挙動**：コード上は確認できるが実行時挙動の確認なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` -- 109-117行目
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar_redirect.html.twig` -- 全体
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 11行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 30-31行目
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` -- 22行目
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/base.html.twig` -- テンプレート継承

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リダイレクトインターセプトはWebDebugToolbarListenerで処理される | E-01 | ○ |
| C-02 | interceptRedirectsオプションが有効時のみ動作 | E-01 (47行目, 109行目) | ○ |
| C-03 | テンプレートはtoolbar_redirect.html.twigである | E-01 (115行目), E-02 | ○ |
| C-04 | テンプレートはbase.html.twigを継承している | E-02 (1行目) | ○ |
| C-05 | location変数にリダイレクト先URLが渡される | E-01 (115行目), E-02 (41行目) | ○ |
| C-06 | absolute_url関数で絶対URLに変換される | E-02 (41行目) | ○ |
| C-07 | Follow redirectボタンでリダイレクト先に遷移する | E-02 (44行目) | ○ |
| C-08 | レスポンスステータスコードが200に変更される | E-01 (116行目) | ○ |
| C-09 | Locationヘッダーが除去される | E-01 (117行目) | ○ |
| C-10 | 本画面は専用ルートを持たない | E-01 (109-117行目でレスポンス置換) | ○ |
| C-11 | 関連機能はWebProfilerBundleとTwigBundle | E-04 | ○ |
| C-12 | header.html.twigがインクルードされる | E-02 (35行目) | ○ |
| C-13 | 本画面はデータベース操作を行わない | E-01, E-02 | ○ |
| C-14 | AutoExpireFlashBag使用時にフラッシュメッセージが延長される | E-01 (110-112行目) | △ |

## 4) 不足情報（Unknown / Missing）
- AutoExpireFlashBag延長動作は、コード上で`setAll(peekAll())`の呼び出しを確認できるが、実行時の副作用やエッジケースに関する確認が不足
  - 候補：ユニットテストの確認 / Symfonyドキュメント / AutoExpireFlashBagのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: リダイレクトインターセプトの基本動作（根拠十分）
- 0: テンプレート構造（根拠十分）
- 1: FlashBag延長動作の副作用（コード確認済みだが実行時検証なし）

## 6) レビュアーチェックリスト（最小）
- [ ] WebDebugToolbarListener 109行目のインターセプト条件が正しく記載されているか確認
- [ ] テンプレート変数（location, host）の説明が実装と一致するか確認
- [ ] 画面遷移（Follow redirectボタン）の動作説明が正確か確認
