---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-Webデバッグツールバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **toolbar_js.html.twigの注入JavaScriptの詳細動作**：テンプレートファイルは存在確認済みだが内容の詳細解析は未実施

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` -- 124-163行目
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.html.twig` -- 全体
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.css.twig` -- 全体
- E-04: `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` -- 全体
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` -- ルート定義
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 12行目
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 32-36行目
- E-08: `src/Symfony/Bundle/WebProfilerBundle/Profiler/TemplateManager.php` -- 全体

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ツールバーはProfilerController::toolbarActionで生成 | E-01, E-05 | ○ |
| C-02 | ルート名は_wdt、URLは/_wdt/{token} | E-05 (18行目) | ○ |
| C-03 | tokenがnull/'empty'の場合は空レスポンス返却 | E-01 (137-139行目) | ○ |
| C-04 | プロファイルが見つからない場合は404返却 | E-01 (143-145行目) | ○ |
| C-05 | テンプレート変数にfull_stack, profile, templates等が渡される | E-01 (154-162行目) | ○ |
| C-06 | toolbar.html.twigでtemplatesをループし各コレクターのtoolbarブロックをレンダリング | E-02 (3-17行目) | ○ |
| C-07 | full_stackがtrueの場合にsymfony/symfony警告が表示される | E-02 (18-33行目) | ○ |
| C-08 | トグルボタンにアクセスキーDが設定 | E-02 (35行目) | ○ |
| C-09 | ツールバーはページ下部に固定表示（position: fixed） | E-03 (63行目) | ○ |
| C-10 | CSS変数によるカラースキーム定義 | E-03 (2-47行目) | ○ |
| C-11 | レスポンシブ対応（768px, 1024pxブレークポイント） | E-03 (527行目, 579行目) | ○ |
| C-12 | 印刷時非表示 | E-03 (627-631行目) | ○ |
| C-13 | WebDebugToolbarListenerで</body>前に注入 | E-04 (160行目) | ○ |
| C-14 | メインリクエスト以外には注入しない | E-04 (87-89行目) | ○ |
| C-15 | XMLHttpRequest時は注入しない | E-04 (101-107行目) | ○ |
| C-16 | CSP nonce対応 | E-01 (423-426行目), E-04 (92-98行目) | ○ |
| C-17 | profiler_markup_versionは3 | E-01 (161行目) | ○ |
| C-18 | toolbar_js.html.twigが注入されるJavaScript実体 | E-04 (163-173行目) | △ |

## 4) 不足情報（Unknown / Missing）
- toolbar_js.html.twigの内容詳細（Ajax呼出し、DOM操作、イベントハンドリング）は未解析
  - 候補：toolbar_js.html.twigの直接読み込み / ブラウザでの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: ツールバーの基本構造とレンダリングフロー（根拠十分）
- 0: ルーティング定義（根拠十分）
- 1: クライアントサイドJavaScriptの動作詳細（toolbar_js.html.twigの解析不足）

## 6) レビュアーチェックリスト（最小）
- [ ] toolbarActionのテンプレート変数がテンプレートでの使用箇所と一致するか確認
- [ ] ルーティング定義（wdt.php）が正しく記載されているか確認
- [ ] 例外処理パターン（token=null, profile not found等）が網羅的か確認
- [ ] toolbar_js.html.twigのAjaxリクエスト仕様を確認
