---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ツールバースタイルシート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` -- 170-184行目
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/toolbar.css.twig` -- 全体
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/wdt.php` -- 15-17行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 13行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 37-38行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は_wdt_stylesheet、URLは/_wdt/styles | E-03 (15-17行目) | ○ |
| C-02 | toolbarStylesheetActionメソッドが処理する | E-01 (170行目), E-03 | ○ |
| C-03 | Content-Typeはtext/css | E-01 (179行目) | ○ |
| C-04 | Cache-Controlはmax-age=600, private | E-01 (181行目) | ○ |
| C-05 | toolbar.css.twigをレンダリング | E-01 (177行目) | ○ |
| C-06 | CSS変数による色定義が含まれる | E-02 (1-47行目) | ○ |
| C-07 | ツールバーはposition: fixed, bottom: 0 | E-02 (63-64行目) | ○ |
| C-08 | レスポンシブ対応（768px, 1024px） | E-02 (527行目, 579行目) | ○ |
| C-09 | 印刷時非表示 | E-02 (627-631行目) | ○ |
| C-10 | CSPがこのアクション内で無効化される | E-01 (174行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Cache-Control値が実装と一致するか確認
- [ ] CSS構造の説明が最新のtoolbar.css.twigと整合しているか確認
