---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-リクエスト情報パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **RequestDataCollectorのゲッターメソッド群の網羅性**：テンプレートから推測しているが、DataCollectorのソースコードは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/request.html.twig` -- 全体
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` -- 65-117行目
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 14行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 39-41行目
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` -- 47-48行目
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` -- 39-41行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはrequest.html.twigである | E-01 | ○ |
| C-02 | layout.html.twigを継承する | E-01 (1行目) | ○ |
| C-03 | ステータスコード色分け（400以上赤、300以上黄、その他緑） | E-01 (44行目) | ○ |
| C-04 | 8つのタブ構成（Request, Response, Cookies, Session, Flashes, Server Parameters, Parent Request, Sub Requests） | E-01 (129-412行目) | ○ |
| C-05 | GETパラメータ、POSTパラメータ、アップロードファイルの表示 | E-01 (140-186行目) | ○ |
| C-06 | JSONリクエスト時のPretty表示 | E-01 (209-219行目) | ○ |
| C-07 | セッション使用状況のトレース表示 | E-01 (317-343行目) | ○ |
| C-08 | Stateless Check表示 | E-01 (307行目) | ○ |
| C-09 | .env変数と通常環境変数の区分表示 | E-01 (364-377行目) | ○ |
| C-10 | 親リクエスト/サブリクエストの表示 | E-01 (380-410行目) | ○ |
| C-11 | set_handlerマクロでコントローラー情報表示 | E-01 (414-431行目) | ○ |
| C-12 | bag.html.twigのインクルード | E-01 (164, 174, 184, 195, 199等) | ○ |
| C-13 | table.html.twigのインクルード | E-01 (285, 295等) | ○ |
| C-14 | panelActionでプロファイルを読み込む | E-02 (79行目) | ○ |
| C-15 | 関連機能はWebProfilerBundle、HttpKernel、HttpFoundation | E-04 | ○ |
| C-16 | RequestDataCollectorのプロパティ一覧 | E-01（テンプレート使用箇所から推測） | △ |

## 4) 不足情報（Unknown / Missing）
- RequestDataCollectorのソースコードを直接確認しておらず、テンプレートで参照されるプロパティからデータ構造を推測
  - 候補：RequestDataCollectorのソースコード確認 / HttpKernelコンポーネントのDataCollector

## 5) リスクフラグ（レビュー観点）
- 0: テンプレート構造とタブ構成（根拠十分）
- 0: ツールバー表示仕様（根拠十分）
- 1: RequestDataCollectorのデータ構造詳細（テンプレートからの推測）

## 6) レビュアーチェックリスト（最小）
- [ ] タブ構成が最新のrequest.html.twigと一致するか確認
- [ ] ステータスコード色分け条件が正確か確認
- [ ] セッション使用状況のトレース表示の動作を確認
- [ ] RequestDataCollectorのプロパティ一覧の網羅性を確認
