---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：15-例外情報パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **HtmlErrorRendererのgetBody()出力の詳細内容**：コントローラーでの呼出しは確認済みだがレンダラー内部は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/exception.html.twig` -- 全体
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ExceptionPanelController.php` -- 全体
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` -- 65-117行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 15行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 42-44行目
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` -- 45-51行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはexception.html.twigである | E-01 | ○ |
| C-02 | layout.html.twigを継承する | E-01 (1行目) | ○ |
| C-03 | ExceptionPanelControllerがbodyとstylesheetを生成 | E-02 (37-57行目) | ○ |
| C-04 | HtmlErrorRendererを使用する | E-02 (29行目, 48行目, 56行目) | ○ |
| C-05 | サブリクエストでbodyとstylesheetが読み込まれる | E-01 (6行目, 42行目) | ○ |
| C-06 | 例外がある場合にパネルが自動選択される | E-03 (89-91行目) | ○ |
| C-07 | 例外がない場合に「No exception was thrown and caught.」表示 | E-01 (38行目) | ○ |
| C-08 | メニューに例外カウント(1)がバッジ表示される | E-01 (18-20行目) | ○ |
| C-09 | 例外なし時はメニューがdisabled | E-01 (14行目) | ○ |
| C-10 | ルート_profiler_exceptionが定義されている | E-06 (45-47行目) | ○ |
| C-11 | ルート_profiler_exception_cssが定義されている | E-06 (48-50行目) | ○ |
| C-12 | profilerがnullの場合NotFoundHttpException | E-02 (39-41行目) | ○ |
| C-13 | exception.css.twigで追加スタイル調整 | E-01 (7行目) | ○ |
| C-14 | HtmlErrorRendererのgetBody()がスタックトレース等の詳細HTMLを出力 | E-02 (48行目) | △ |

## 4) 不足情報（Unknown / Missing）
- HtmlErrorRendererの出力内容の詳細（スタックトレース、コードスニペット、例外チェーン等の具体的なHTML構造）
  - 候補：HtmlErrorRendererのソースコード / ErrorHandlerコンポーネントのテストケース

## 5) リスクフラグ（レビュー観点）
- 0: テンプレート構造とコントローラー連携（根拠十分）
- 0: ルーティング定義（根拠十分）
- 1: HtmlErrorRendererの出力詳細（外部コンポーネント依存）

## 6) レビュアーチェックリスト（最小）
- [ ] ExceptionPanelControllerのbody/stylesheetメソッドの呼出しが正確か確認
- [ ] render(controller(...))によるサブリクエスト処理の説明が適切か確認
- [ ] 例外自動選択ロジック（panelAction 89-91行目）の条件が正確か確認
