---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：16-パフォーマンス（時間）パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **time.jsのJavaScript動作詳細**：source関数で読み込まれるがファイル内容は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/time.html.twig` -- 全体
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` -- 65-117行目
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 16行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 45-47行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはtime.html.twigである | E-01 | ○ |
| C-02 | layout.html.twigを継承する | E-01 (1行目) | ○ |
| C-03 | ツールバーで合計時間を表示、1000ms超でyellow | E-01 (43-45行目) | ○ |
| C-04 | パフォーマンスメトリクス（duration, inittime）を表示 | E-01 (78-89行目) | ○ |
| C-05 | メモリ使用量はmemoryコレクターから取得 | E-01 (91-98行目) | ○ |
| C-06 | サブリクエスト数とその合計時間を表示 | E-01 (100-118行目) | ○ |
| C-07 | しきい値フィルタリング機能あり | E-01 (137-142行目) | ○ |
| C-08 | Stopwatch未インストール時のメッセージ表示 | E-01 (123-126行目) | ○ |
| C-09 | サブリクエストはストライプ背景パターンで区別 | E-01 (176-182行目) | ○ |
| C-10 | dump_eventsマクロでイベントデータをJSON化 | E-01 (202-229行目) | ○ |
| C-11 | display_timelineマクロでSVGタイムライン描画 | E-01 (231-249行目) | ○ |
| C-12 | time.css.twigのインクルード | E-01 (184行目) | ○ |
| C-13 | time.jsのsource読み込み | E-01 (187行目) | ○ |
| C-14 | サブリクエストへのリンク表示 | E-01 (168行目) | ○ |
| C-15 | TimelineEngine, SvgRenderer, Legend等のJavaScriptクラスの動作 | E-01 (237-246行目) | △ |

## 4) 不足情報（Unknown / Missing）
- time.jsの内容（TimelineEngine, SvgRenderer, Legend, Themeクラスの実装詳細）
  - 候補：time.jsファイルの直接確認 / ブラウザでの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: テンプレート構造とデータフロー（根拠十分）
- 0: パフォーマンスメトリクスの表示（根拠十分）
- 1: JavaScriptタイムライン描画の詳細動作（time.js未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンスメトリクスの単位と表示形式が正確か確認
- [ ] しきい値フィルタリングの動作説明が正確か確認
- [ ] サブリクエストの表示仕様が実装と一致するか確認
