---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-メモリ使用量パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/memory.html.twig` -- 全体（25行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 17行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 48-49行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはmemory.html.twigである | E-01 | ○ |
| C-02 | layout.html.twigを継承する | E-01 (1行目) | ○ |
| C-03 | toolbarブロックのみ定義（menu/panelブロックなし） | E-01 (全体) | ○ |
| C-04 | 50MiB超でステータス色がyellow | E-01 (5行目) | ○ |
| C-05 | メモリ値をMiBに変換（/1024/1024、小数第1位） | E-01 (7行目) | ○ |
| C-06 | メモリ制限が-1の場合「Unlimited」表示 | E-01 (19行目) | ○ |
| C-07 | クリック先がtimeパネル（name: 'time'指定） | E-01 (23行目) | ○ |
| C-08 | ピークメモリ使用量とPHPメモリ制限の2項目を表示 | E-01 (12-20行目) | ○ |
| C-09 | memory.svgアイコンを表示 | E-01 (6行目) | ○ |
| C-10 | 関連機能はWebProfilerBundleとHttpKernel | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張にソースコード根拠あり（テンプレートが25行と小さく全体を確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] メモリ閾値（50MiB）が実装と一致するか確認
- [ ] name: 'time'によるリンク先が意図通りか確認
