---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-ログパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **LoggerDataCollectorのprocessedLogsデータ構造の完全性**：テンプレートから推測しているがDataCollectorソースは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/logger.html.twig` -- 全体（582行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 18行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 50-52行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはlogger.html.twigである | E-01 | ○ |
| C-02 | layout.html.twigを継承する | E-01 (1行目) | ○ |
| C-03 | 3タイプフィルタ（All/Errors/Deprecations） | E-01 (377-397行目) | ○ |
| C-04 | 優先度フィルタ（チェックボックスドロップダウン） | E-01 (399-418行目) | ○ |
| C-05 | チャネルフィルタ（チェックボックスドロップダウン） | E-01 (420-439行目) | ○ |
| C-06 | DEBUGログがデフォルト非表示 | E-01 (413行目: 'debug' != value ? 'checked') | ○ |
| C-07 | eventチャネルがデフォルト非表示 | E-01 (434行目: 'event' != value ? 'checked') | ○ |
| C-08 | エラーあり時はErrorsタブが初期選択 | E-01 (379行目) | ○ |
| C-09 | SymfonyProfilerLoggerPanel JSクラスによるフィルタリング | E-01 (244-318行目) | ○ |
| C-10 | data-type, data-priority, data-channel属性によるフィルタ | E-01 (461行目) | ○ |
| C-11 | render_log_messageマクロでログフォーマット | E-01 (540-581行目) | ○ |
| C-12 | コンテナコンパイルログの折りたたみ表示 | E-01 (496-537行目) | ○ |
| C-13 | タイムスタンプのユーザータイムゾーン変換対応 | E-01 (463行目) | ○ |
| C-14 | ツールバーでエラー/警告/非推奨カウント表示 | E-01 (323-350行目) | ○ |
| C-15 | Select All/Select Noneボタン | E-01 (406-408行目, 427-429行目) | ○ |
| C-16 | processedLogsの完全なデータ構造 | E-01（テンプレート使用から推測） | △ |

## 4) 不足情報（Unknown / Missing）
- LoggerDataCollectorのprocessedLogsプロパティの完全な定義（型、必須/任意フィールド）
  - 候補：LoggerDataCollectorのソースコード確認

## 5) リスクフラグ（レビュー観点）
- 0: テンプレート構造とフィルタUI（根拠十分）
- 0: JavaScriptフィルタロジック（根拠十分）
- 1: DataCollectorのデータ構造詳細

## 6) レビュアーチェックリスト（最小）
- [ ] フィルタのデフォルト状態（DEBUGオフ、eventオフ）が正確か確認
- [ ] ツールバーの表示条件（エラー/警告/非推奨がある場合のみ表示）が正確か確認
- [ ] processedLogsのデータ構造がDataCollectorと一致するか確認
