---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-イベントパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/events.html.twig` -- 全体（127行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 19行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 53-55行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはevents.html.twigである | E-01 | ○ |
| C-02 | layout.html.twigを継承する | E-01 (1行目) | ○ |
| C-03 | ディスパッチャー名でタブ切替 | E-01 (14行目) | ○ |
| C-04 | Called Listeners / Not Called Listeners / Orphaned Eventsの3分類 | E-01 (23-83行目) | ○ |
| C-05 | render_tableマクロでリスナーテーブル生成 | E-01 (92-126行目) | ○ |
| C-06 | イベント名によるグループ化 | E-01 (101-114行目) | ○ |
| C-07 | リスナーのpriority表示 | E-01 (117行目) | ○ |
| C-08 | profiler_dumpでリスナーstub表示 | E-01 (118行目) | ○ |
| C-09 | 各タブにバッジでカウント表示 | E-01 (25行目, 33行目, 53行目) | ○ |
| C-10 | イベントなし時のメッセージ表示 | E-01 (19-20行目) | ○ |
| C-11 | Not Called Listenersなし時のメッセージ | E-01 (36-46行目) | ○ |
| C-12 | Orphaned Eventsなし時のメッセージ | E-01 (55-66行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 3分類（Called/Not Called/Orphaned）の表示内容が実装と一致するか確認
- [ ] render_tableマクロのグループ化ロジックが正確か確認
