---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-プロファイラーパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 65-117行目（panelActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 419-431行目（renderWithCspNoncesメソッド）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 410-417行目（denyAccessIfProfilerDisabledメソッド）
- E-04: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 39-41行目（_profilerルート）
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Profiler/TemplateManager.php` 39-83行目（getName/getNamesメソッド）
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` 全体
- E-07: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/base.html.twig` 全体
- E-08: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/info.html.twig` 全体
- E-09: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/settings.html.twig` 全体
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 5-8行目
- E-11: `docs/code-to-docs/画面一覧/画面遷移図.md` 73-97行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler`、URLパターンは`/{token}`である | E-04 | ○ |
| C-02 | panelActionはtoken, panel, page, typeのパラメータを受け取る | E-01 | ○ |
| C-03 | `latest`トークンは最新プロファイルに置換される | E-01 (75-77行目) | ○ |
| C-04 | プロファイルが見つからない場合はinfo.html.twigが表示される | E-01 (79-81行目), E-08 | ○ |
| C-05 | パネル未指定時のデフォルトはプロファイルタイプ名である | E-01 (85-86行目) | ○ |
| C-06 | 例外がある場合はexceptionパネルが優先表示される | E-01 (88-93行目) | ○ |
| C-07 | dumpデータがある場合はdumpパネルが優先表示される | E-01 (95-97行目) | ○ |
| C-08 | TemplateManagerでテンプレート名を解決する | E-01 (105行目), E-05 | ○ |
| C-09 | CSP nonceがテンプレートに渡される | E-02 | ○ |
| C-10 | profiler_markup_versionは3である | E-01 (114行目) | ○ |
| C-11 | Ajaxリクエストの判定がis_ajaxフラグとして渡される | E-01 (113行目) | ○ |
| C-12 | サイドバーにコレクターメニューが動的生成される | E-06 (38-59行目) | ○ |
| C-13 | requestタイプではcommandコレクターが除外される | E-06 (39-40行目) | ○ |
| C-14 | commandタイプではrequestとrouterコレクターが除外される | E-06 (41-42行目) | ○ |
| C-15 | settings.html.twigがサイドバーにインクルードされる | E-06 (63行目) | ○ |
| C-16 | テーマ設定はlocalStorageで管理される | E-07 (28-37行目), E-09 (258-315行目) | ○ |
| C-17 | base.html.twigがCSP nonce付きでスタイル・スクリプトを出力する | E-07 (17-18行目, 27行目) | ○ |
| C-18 | パネルが存在しない場合はNotFoundHttpExceptionがスローされる | E-01 (101-103行目) | ○ |
| C-19 | プロファイラー無効時はNotFoundHttpExceptionがスローされる | E-03 | ○ |
| C-20 | 画面遷移図でツールバーからパネルへの遷移が定義されている | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張にソースコードまたはドキュメントの根拠が確認されている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが明確であり、全ての主張が検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] panelActionメソッドの処理フローが設計書の記述と一致しているか確認
- [ ] パネル自動選択のロジック（例外→dump→デフォルト）が正しく記述されているか確認
- [ ] テンプレートファイルのインクルード関係が正確か確認
- [ ] サイドバーのフィルタリングロジック（request/commandタイプ別）が正しいか確認
