---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-ルーティングパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **TraceableUrlMatcherのトレース出力構造の詳細**：RouterControllerでの呼出しは確認済みだがTraceableUrlMatcherのソースは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/router.html.twig` -- 全体（15行）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Router/panel.html.twig` -- 全体（72行）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` -- 全体（100行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 20行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 56-57行目
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` -- 42-44行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | router.html.twigがpanelブロックでRouterController::panelActionへサブリクエスト | E-01 (13行目) | ○ |
| C-02 | RouterController::panelActionがルーティングトレースを生成 | E-03 (53-75行目) | ○ |
| C-03 | TraceableUrlMatcherを使用 | E-03 (93行目) | ○ |
| C-04 | Router/panel.html.twigが実際のパネル内容を描画 | E-02, E-03 (70行目) | ○ |
| C-05 | マッチしたルート名がメトリクスとして表示 | E-02 (3-8行目) | ○ |
| C-06 | ルートパラメータがテーブル表示 | E-02 (10-19行目) | ○ |
| C-07 | リダイレクト情報の表示 | E-02 (22-30行目) | ○ |
| C-08 | マッチングログテーブルの表示（#, Route name, Path, Log） | E-02 (38-66行目) | ○ |
| C-09 | トレースレベルによる色分け（0=通常, 1=warning, 2=success） | E-02 (49行目) | ○ |
| C-10 | ルーターが無効の場合のメッセージ表示 | E-03 (62行目) | ○ |
| C-11 | ExpressionLanguageProviderのサポート | E-03 (94-96行目) | ○ |
| C-12 | _profiler_routerルートの定義 | E-06 (42-44行目) | ○ |
| C-13 | ツールバーブロックが空 | E-01 (3行目) | ○ |
| C-14 | 注意メッセージ「現在のルーター設定に基づく」 | E-02 (68-71行目) | ○ |
| C-15 | TraceableUrlMatcherの戻り値の構造（name, path, level, log） | E-02（テンプレート使用から推測） | △ |

## 4) 不足情報（Unknown / Missing）
- TraceableUrlMatcher::getTracesForRequest()の戻り値の正確な構造定義
  - 候補：TraceableUrlMatcherのソースコード / Routingコンポーネントのテストケース

## 5) リスクフラグ（レビュー観点）
- 0: 2段構成のパネル構造（根拠十分）
- 0: ルーティング定義（根拠十分）
- 1: TraceableUrlMatcherのトレース出力構造（外部コンポーネント依存）

## 6) レビュアーチェックリスト（最小）
- [ ] サブリクエストによるパネル描画の仕組みが正確か確認
- [ ] トレースレベル色分け条件が実装と一致するか確認
- [ ] RouterControllerのgetTracesメソッドの動作説明が正確か確認
- [ ] TraceableUrlMatcherの戻り値フィールドの確認
