---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-ルーター詳細パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ExpressionLanguageプロバイダーの具体的な影響**：実行時の動作確認が望ましい

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php`
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Router/panel.html.twig`
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/router.html.twig`
- E-04: `src/Symfony/Component/HttpKernel/DataCollector/RouterDataCollector.php`
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/_profiler/{token}/router` | E-05 (42行目) | ○ |
| C-02 | ルート名は `_profiler_router` | E-05 (42行目) | ○ |
| C-03 | コントローラーは `RouterController::panelAction` | E-01 (53行目), E-05 (43行目) | ○ |
| C-04 | Profilerがnullの場合NotFoundHttpExceptionがスローされる | E-01 (55-57行目) | ○ |
| C-05 | Router/Routesがnullの場合「The Router is not enabled.」を返す | E-01 (61-63行目) | ○ |
| C-06 | TraceableUrlMatcherでマッチングトレースを生成 | E-01 (93行目, 98行目) | ○ |
| C-07 | テンプレートは `@WebProfiler/Router/panel.html.twig` | E-01 (70行目) | ○ |
| C-08 | マッチしたルート名がメトリクスに表示される | E-02 (5行目) | ○ |
| C-09 | ルートパラメータがテーブルに表示される | E-02 (11-19行目) | ○ |
| C-10 | リダイレクト情報が条件付きで表示される | E-02 (22-30行目) | ○ |
| C-11 | マッチングログがテーブルに#, Route name, Path, Logで表示される | E-02 (38-66行目) | ○ |
| C-12 | level値により色分け表示される（1=warning, 2=success） | E-02 (49行目) | ○ |
| C-13 | router.html.twigからrender(controller())で呼び出される | E-03 (13行目) | ○ |
| C-14 | RouterDataCollectorはredirect, url, routeデータを収集 | E-04 (40-45行目, 55-59行目) | ○ |
| C-15 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-06 (22行目) | ○ |
| C-16 | 関連機能はWebProfilerBundle(63), Routing(3), HttpKernel(2) | E-07 (58-60行目) | ○ |
| C-17 | Profilerの無効化が行われる（自身のリクエスト記録防止） | E-01 (59行目) | ○ |
| C-18 | ExpressionLanguageプロバイダーがトレースに影響を与える | E-01 (94-96行目) | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: ExpressionLanguageプロバイダーの具体的な影響範囲は、ルート定義のcondition属性の有無に依存するため、実行時の環境に依存する
  - 候補：Routingコンポーネントのcondition機能のドキュメント / ExpressionLanguageの設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートの表示構造とコントローラーのロジックは直接ソースコードから確認済み
- 0: 低リスク - ルーティング定義は設定ファイルから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] マッチングログのlevel値による色分けが正しいか実際のブラウザで確認
- [ ] ExpressionLanguageプロバイダーの設定がプロジェクトに存在するか確認
- [ ] TraceableUrlMatcherの動作が現在のルーター設定と一致するか確認
