---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-フォームパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **FormDataExtractorInterfaceの詳細実装**：データ抽出の詳細ロジック確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/form.html.twig`
- E-02: `src/Symfony/Component/Form/Extension/DataCollector/FormDataCollector.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは form.html.twig | E-01 | ○ |
| C-02 | ツールバーにフォーム数とエラー数を表示 | E-01 (4-25行目) | ○ |
| C-03 | エラーあり時はステータスカラーが赤 | E-01 (5行目) | ○ |
| C-04 | パネルにツリーメニューと詳細コンテナの2カラム構成 | E-01 (382-394行目) | ○ |
| C-05 | 6つのタブ（Errors, Default Data, Submitted Data, Passed Options, Resolved Options, View Vars） | E-01 (444-492行目) | ○ |
| C-06 | エラーテーブルにMessage, Origin, Cause列 | E-01 (505-509行目) | ○ |
| C-07 | フォームなし時「No forms were submitted.」表示 | E-01 (396-398行目) | ○ |
| C-08 | フォームツリーは再帰的マクロで表示 | E-01 (402-431行目) | ○ |
| C-09 | ツリー開閉状態をsessionStorageで保存 | E-01 (354-356行目) | ○ |
| C-10 | FormDataCollectorのcollect()は空実装 | E-02 (76-78行目) | ○ |
| C-11 | エラーあり時はErrorsタブがアクティブ | E-01 (445行目) | ○ |
| C-12 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-03 (24行目) | ○ |
| C-13 | 関連機能はWebProfilerBundle(63), Form(34), Validator(33) | E-04 (63-65行目) | ○ |
| C-14 | profiler_dump()でVarDumper表示 | E-01 (439, 528行目等) | ○ |
| C-15 | SymfonyProfilerFormPanelクラスがJS操作を制御 | E-01 (205行目) | ○ |
| C-16 | FormDataExtractorInterfaceによりフォームデータが抽出される | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: FormDataExtractorInterfaceの具体的な実装クラスの動作詳細は確認されていない
  - 候補：FormDataExtractor.php / FormDataExtractorInterface.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートの表示構造はソースコードから確認済み
- 0: 低リスク - JavaScriptのツリー操作ロジックはテンプレート内のスクリプトから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] フォームツリーの階層表示が正しく動作するか確認
- [ ] 各タブの切り替え動作を確認
- [ ] エラー表示のスタイリング（赤色バッジ等）を確認
