---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-翻訳パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/translation.html.twig`
- E-02: `src/Symfony/Component/Translation/DataCollectorTranslator.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは translation.html.twig | E-01 | ○ |
| C-02 | Missing時は赤色、Fallback時は黄色のステータスカラー | E-01 (7行目) | ○ |
| C-03 | 3つのタブ（Defined/Fallback/Missing）で分類 | E-01 (91-154行目) | ○ |
| C-04 | メッセージ振り分けにMESSAGE_DEFINED等の定数を使用 | E-01 (82-88行目), E-02 (24-26行目) | ○ |
| C-05 | テーブル列にLocale, Domain, Times used, Message ID, Message Preview | E-01 (186-194行目) | ○ |
| C-06 | Fallbackタブのみ追加のFallback locale列 | E-01 (188-189行目, 200-202行目) | ○ |
| C-07 | パラメータ表示のトグルボタン | E-01 (213-219行目) | ○ |
| C-08 | グローバルパラメータテーブル | E-01 (159-178行目) | ○ |
| C-09 | DataCollectorTranslatorはデコレーターパターン | E-02 (22行目, 30-32行目) | ○ |
| C-10 | trans()でcollectMessage()を呼び出す | E-02 (42-43行目) | ○ |
| C-11 | MESSAGE_DEFINED=0, MESSAGE_MISSING=1, MESSAGE_EQUALS_FALLBACK=2 | E-02 (24-26行目) | ○ |
| C-12 | 翻訳なし時「No translations have been called.」 | E-01 (72-75行目) | ○ |
| C-13 | Missingあり時はMissingタブがアクティブ | E-01 (133行目) | ○ |
| C-14 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-03 (27行目) | ○ |
| C-15 | 関連機能はWebProfilerBundle(63), Translation(51) | E-04 (70-71行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードにより直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 3タブ（Defined/Fallback/Missing）の切り替え動作を確認
- [ ] パラメータ表示のトグル動作を確認
- [ ] Missing/Fallbackのステータスカラーが正しく表示されるか確認
