---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：27-セキュリティパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **SecurityDataCollector::collect()の全データ構造**：長いcollect()メソッドの完全な確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/SecurityBundle/Resources/views/Collector/security.html.twig`
- E-02: `src/Symfony/Bundle/SecurityBundle/DataCollector/SecurityDataCollector.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはSecurityBundle提供 | E-01, E-03 (28行目) | ○ |
| C-02 | 5つのタブ構成（Token, Firewall, Listeners, Authenticators, Access Decision） | E-01 (201-606行目) | ○ |
| C-03 | ツールバーにユーザー名、認証状態、ロール表示 | E-01 (86-188行目) | ○ |
| C-04 | なりすまし情報の条件付き表示 | E-01 (94-101行目) | ○ |
| C-05 | ログアウトリンクの条件付き表示 | E-01 (168-178行目) | ○ |
| C-06 | Firewallタブにprovider, context等の設定表示 | E-01 (300-338行目) | ○ |
| C-07 | Authenticatorsにsuccess/failure/skippedステータス | E-01 (407-413行目) | ○ |
| C-08 | Access DecisionログにGRANTED/DENIED/ERROR | E-01 (538-544行目) | ○ |
| C-09 | 投票者詳細のトグル表示 | E-01 (566-597行目) | ○ |
| C-10 | SecurityDataCollectorはLateDataCollectorInterface実装 | E-02 (38行目) | ○ |
| C-11 | 複数のサービス依存（42-48行目） | E-02 (42-48行目) | ○ |
| C-12 | VoterInterface定数でACCESS_GRANTED等を参照 | E-01 (577-584行目) | ○ |
| C-13 | 認証元プロファイルへのリンク | E-01 (218-227行目) | ○ |
| C-14 | セキュリティ無効時のメッセージ | E-01 (179-183行目) | ○ |
| C-15 | トークンなし時のメッセージ | E-01 (264-275行目) | ○ |
| C-16 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-03 (28行目) | ○ |
| C-17 | 関連機能はSecurityBundle(23), Security Core(20), Security HTTP(21), WebProfilerBundle(63) | E-04 (72-75行目) | ○ |
| C-18 | collect()メソッドの全データ構造の網羅性 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: SecurityDataCollector::collect()は非常に長いメソッドであり、先頭60行のみ読み込んだため全体のデータ構造が確認されていない
  - 候補：SecurityDataCollector.php の完全な読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートの表示構造は直接ソースコードから確認済み
- 1: 中リスク - データコレクターの全データ構造の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 5つのタブの切り替え動作を確認
- [ ] Authenticatorのトグル表示が正しく動作するか確認
- [ ] Access Decision投票者詳細のトグル動作を確認
- [ ] なりすまし状態での表示を確認
