---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-Twigパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/twig.html.twig`
- E-02: `src/Symfony/Bridge/Twig/DataCollector/TwigDataCollector.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは twig.html.twig | E-01 | ○ |
| C-02 | ツールバーにレンダリング時間をms単位で表示 | E-01 (41, 44-45行目) | ○ |
| C-03 | メトリクスにRender time, Template calls, Block calls, Macro calls | E-01 (103-125行目) | ○ |
| C-04 | テンプレート一覧にTemplate Name & PathとRender Count列 | E-01 (136-139行目) | ○ |
| C-05 | file_linkフィルタでファイルリンクを生成 | E-01 (51, 145行目) | ○ |
| C-06 | file_relativeフィルタでパスを表示 | E-01 (150行目) | ○ |
| C-07 | 呼び出しグラフをcollector.htmlcallgraphで表示 | E-01 (165行目) | ○ |
| C-08 | テンプレートなし時「No Twig templates were rendered.」 | E-01 (96-98行目) | ○ |
| C-09 | サブリクエスト注記メッセージ | E-01 (128-130行目) | ○ |
| C-10 | TwigDataCollectorはLateDataCollectorInterface実装 | E-02 (29行目) | ○ |
| C-11 | Twig\Profiler\Profileに依存 | E-02 (34行目) | ○ |
| C-12 | lateCollect()でprofileをシリアライズ | E-02 (52行目) | ○ |
| C-13 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-03 (29行目) | ○ |
| C-14 | 関連機能はWebProfilerBundle(63), Twig Bridge(36), TwigBundle(35) | E-04 (76-78行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードにより直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレートファイルリンクが正しく動作するか確認
- [ ] 呼び出しグラフの表示が正しいか確認
