---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-HTTPクライアントパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/http_client.html.twig`
- E-02: `src/Symfony/Component/HttpClient/DataCollector/HttpClientDataCollector.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは http_client.html.twig | E-01 | ○ |
| C-02 | ツールバーにリクエスト数とエラー数を表示 | E-01 (39-55行目) | ○ |
| C-03 | エラーあり時は赤色表示 | E-01 (53行目) | ○ |
| C-04 | クライアント別タブ構成 | E-01 (91-171行目) | ○ |
| C-05 | ステータスコード500以上=error、400以上=warning、それ以外=success | E-01 (146-152行目) | ○ |
| C-06 | x-debug-tokenヘッダーからプロファイラーリンク生成 | E-01 (105-113行目) | ○ |
| C-07 | cURLコマンドコピーボタン | E-01 (129-132行目) | ○ |
| C-08 | リクエストオプションのprofiler_dump表示 | E-01 (140行目) | ○ |
| C-09 | リクエストなし時「No HTTP requests were made.」 | E-01 (76-78行目) | ○ |
| C-10 | クライアント別リクエストなし時のメッセージ | E-01 (97-99行目) | ○ |
| C-11 | HttpClientDataCollectorはLateDataCollectorInterface実装 | E-02 (27行目) | ○ |
| C-12 | collect()内でlateCollect()を呼び出す | E-02 (43行目) | ○ |
| C-13 | TraceableHttpClientの配列を保持 | E-02 (34行目) | ○ |
| C-14 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-03 (30行目) | ○ |
| C-15 | 関連機能はWebProfilerBundle(63), HttpClient(4) | E-04 (79-80行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードにより直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] クライアント別タブの切り替え動作を確認
- [ ] ステータスコードの色分け表示を確認
- [ ] cURLコピーボタンの動作を確認
- [ ] プロファイラーリンクの動作を確認
