---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-プロファイラー検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 264-309行目（searchActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 18-19行目（_profiler_searchルート）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/search.html.twig` 2行目（フォームのaction属性）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 26-28行目（SEARCH_BARからSEARCH、SEARCHからPANEL/SEARCH_RESULTSへの遷移）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 9-12行目（画面No.3の機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler_search`である | E-02 | ○ |
| C-02 | URLパターンは`/search`である | E-02 | ○ |
| C-03 | 9種類の検索パラメータ（ip, method, status_code, url, start, end, limit, token, type）を受け取る | E-01 (268-276行目) | ○ |
| C-04 | _stateless属性がfalseかつセッション存在時にセッションに保存する | E-01 (278行目) | ○ |
| C-05 | 9つのセッションキーに検索条件を保存する | E-01 (281-289行目) | ○ |
| C-06 | トークン指定時は_profilerルートへリダイレクトする | E-01 (292-293行目) | ○ |
| C-07 | トークン未指定時はProfiler::find()で検索する | E-01 (296行目) | ○ |
| C-08 | virtual_typeによるフィルタリングコールバックが使用される | E-01 (296行目) | ○ |
| C-09 | 検索結果がある場合は先頭トークンを使用する | E-01 (299行目) | ○ |
| C-10 | 検索結果がない場合は'empty'トークンを使用する | E-01 (299行目) | ○ |
| C-11 | リダイレクト時にHTTP 302ステータスコードを使用する | E-01 (293行目, 308行目) | ○ |
| C-12 | Content-Typeはtext/htmlが設定される | E-01 (293行目, 308行目) | ○ |
| C-13 | typeパラメータのデフォルト値は'request'である | E-01 (276行目) | ○ |
| C-14 | 検索フォームのaction属性が_profiler_searchルートを指している | E-03 | ○ |
| C-15 | 画面遷移図でSEARCH→PANEL（トークン指定時）が定義されている | E-04 | ○ |
| C-16 | 画面遷移図でSEARCH→SEARCH_RESULTS（トークン未指定時）が定義されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 検索処理とリダイレクトのみの単純な処理

## 6) レビュアーチェックリスト（最小）
- [ ] searchActionメソッドの処理フローが設計書の記述と一致しているか確認
- [ ] セッション保存のキー名が正確か確認
- [ ] リダイレクト先のルート名とパラメータが正しいか確認
