---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-メーラーパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/mailer.html.twig`
- E-02: `src/Symfony/Component/Mailer/DataCollector/MessageDataCollector.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは mailer.html.twig | E-01 | ○ |
| C-02 | ツールバーにメール数、Queued/Sent数を表示 | E-01 (191-212行目) | ○ |
| C-03 | 2通以上時にメール一覧テーブルを表示 | E-01 (266-304行目) | ○ |
| C-04 | メール一覧に#, Subject, To列 | E-01 (271-274行目) | ○ |
| C-05 | メール詳細に件名、From、To、その他ヘッダー | E-01 (341-373行目) | ○ |
| C-06 | 添付ファイル一覧とダウンロードリンク | E-01 (377-403行目) | ○ |
| C-07 | Text content、HTML preview、HTML contentの3タブ | E-01 (408-457行目) | ○ |
| C-08 | HTMLプレビューがiframeで表示 | E-01 (434行目) | ○ |
| C-09 | MIMEパーツタブ | E-01 (480-485行目) | ○ |
| C-10 | Raw MessageタブとEMLダウンロード | E-01 (487-497行目) | ○ |
| C-11 | data URIでbase64エンコードによるダウンロード | E-01 (399, 434, 490行目) | ○ |
| C-12 | 送信状態バッジ（Queued=warning, Sent=success） | E-01 (321行目) | ○ |
| C-13 | トランスポート別分岐（複数トランスポート時） | E-01 (254-261行目) | ○ |
| C-14 | MessageDataCollectorはMessageLoggerListenerから取得 | E-02 (27-29行目) | ○ |
| C-15 | base64Encode()ヘルパーメソッド | E-02 (45-48行目) | ○ |
| C-16 | SymfonyProfilerMailerPanelクラスでJS制御 | E-01 (169-187行目) | ○ |
| C-17 | 画面カテゴリは「WebProfilerBundle - コレクターパネル」 | E-03 (31行目) | ○ |
| C-18 | 関連機能はWebProfilerBundle(63), Mailer(40), Mime(42) | E-04 (81-83行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードにより直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] メール一覧の選択切替が正しく動作するか確認
- [ ] HTMLプレビューのiframe表示が正しいか確認
- [ ] 添付ファイルのダウンロードが動作するか確認
- [ ] EMLファイルのダウンロードが動作するか確認
- [ ] 文字エンコーディング変換が正しく行われるか確認
