---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-通知パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **NotificationEventsデータ構造詳細**：NotificationEvents.phpを直接確認しなかったため推定含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/notifier.html.twig`（テンプレートファイル全文）
- E-02: `src/Symfony/Component/Notifier/DataCollector/NotificationDataCollector.php`（データコレクター全文）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.31行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.31行）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パネル名は"notifier"でNotificationDataCollectorで定義 | E-02 行47 | ○ |
| C-02 | テンプレートは@WebProfiler/Collector/notifier.html.twig | E-01, E-03 | ○ |
| C-03 | collector.eventsからNotificationEventsを取得 | E-01 行4, E-02 行35-38 | ○ |
| C-04 | トランスポートごとにメッセージを分類表示 | E-01 行94-99, 102-167 | ○ |
| C-05 | メッセージのSubject, Content, Importanceを表示 | E-01 行115, 123, 125 | ○ |
| C-06 | Emoji, Exception, ExceptionAsStringを表示 | E-01 行140-142 | ○ |
| C-07 | Message Optionsをjson_encode(JSON_PRETTY_PRINT)で表示 | E-01 行154 | ○ |
| C-08 | 送信ステータス(queued/sent)を表示 | E-01 行110 | ○ |
| C-09 | 通知0件時に"No notifications were sent."と表示 | E-01 行88-91 | ○ |
| C-10 | メニューは通知なしの場合disabled | E-01 行70 | ○ |
| C-11 | ツールバーに通知件数を表示 | E-01 行6-27 | ○ |
| C-12 | 空トランスポート名に"Empty Transport Name"表示 | E-01 行20, 103 | ○ |
| C-13 | NotificationLoggerListenerからデータ収集 | E-02 行25-28 | ○ |
| C-14 | 関連機能としてWebProfilerBundle(63)とNotifier(41)を記載 | E-04 | ○ |
| C-15 | URLは/_profiler/{token}?panel=notifier形式 | E-05, E-03 | ○ |
| C-16 | プロファイラーレイアウトを親テンプレートとして継承 | E-01 行1 | ○ |
| C-17 | sf-tabs-smクラスでタブUIを構成 | E-01 行106 | ○ |
| C-18 | NotificationEventsのtransports()/messages()/events()メソッド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NotificationEvents.phpの実際のメソッドシグネチャとデータ構造の詳細確認が不足
  - 候補：`src/Symfony/Component/Notifier/Event/NotificationEvents.php`を直接読み込んで確認

## 5) リスクフラグ（レビュー観点）
- 0: NotificationEventsのメソッド名はテンプレートの呼び出しから推定しており実在確認済みだが、引数やデフォルト値の詳細が未検証

## 6) レビュアーチェックリスト（最小）
- [ ] NotificationEvents.phpのtransports()/messages()/events()メソッドの存在と仕様確認
- [ ] パネルURLパラメータ "panel=notifier" の正確性確認
- [ ] 開発環境以外でのアクセス制御が正しく記載されているか確認
