---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-Messengerパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **TraceableMessageBusのディスパッチ記録構造の詳細**：TraceableMessageBus.phpを直接確認しなかったため推定含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/messenger.html.twig`（テンプレートファイル全文）
- E-02: `src/Symfony/Component/Messenger/DataCollector/MessengerDataCollector.php`（データコレクター全文）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.32行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.32行）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コレクター名は"messenger" | E-02 行59-62 | ○ |
| C-02 | テンプレートは@WebProfiler/Collector/messenger.html.twig | E-01, E-03 | ○ |
| C-03 | LateDataCollectorInterfaceを実装 | E-02 行26 | ○ |
| C-04 | lateCollect()でcallTime順にソート | E-02 行53 | ○ |
| C-05 | 複数バス時にタブ切替UIを表示 | E-01 行92-117 | ○ |
| C-06 | バスが1つの場合はタブ省略 | E-01 行88-91 | ○ |
| C-07 | メッセージクラス名をprofiler_dumpで表示 | E-01 行131 | ○ |
| C-08 | Caller情報（ファイル名・行番号）を表示 | E-01 行143-170 | ○ |
| C-09 | Envelope stamps（ディスパッチ前後）を表示 | E-01 行184-203 | ○ |
| C-10 | 例外発生時に"exception"ラベル表示 | E-01 行132-134 | ○ |
| C-11 | 例外オブジェクトをprofiler_dump(maxDepth:1)で表示 | E-01 行208 | ○ |
| C-12 | ツールバーに例外時赤ステータス | E-01 行44, 65 | ○ |
| C-13 | メニューにexceptionsCountバッジ | E-01 行70-78 | ○ |
| C-14 | 空メッセージ時に"No messages have been collected."表示 | E-01 行84-87 | ○ |
| C-15 | "No items"表示（Stamps空時） | E-01 行188 | ○ |
| C-16 | ソースコード抜粋をトグル表示 | E-01 行160-169 | ○ |
| C-17 | 最初のメッセージがデフォルト展開 | E-01 行129 | ○ |
| C-18 | collectMessage()でデバッグ表現構築 | E-02 行82-107 | ○ |
| C-19 | メッセージ内容をprofiler_dump(maxDepth:2)で表示 | E-01 行180 | ○ |
| C-20 | TraceableMessageBusのgetDispatchedMessages()からデータ取得 | E-02 行46 | △ |

## 4) 不足情報（Unknown / Missing）
- TraceableMessageBus.phpの実際のディスパッチメッセージ記録構造の詳細が未検証
  - 候補：`src/Symfony/Component/Messenger/TraceableMessageBus.php`を直接読み込んで確認

## 5) リスクフラグ（レビュー観点）
- 0: TraceableMessageBusのgetDispatchedMessages()の戻り値構造はMessengerDataCollectorの使用パターンから推定

## 6) レビュアーチェックリスト（最小）
- [ ] TraceableMessageBus.phpのgetDispatchedMessages()の戻り値構造の確認
- [ ] stamps_after_dispatchの存在条件の確認
- [ ] バスタブのステータスカラー（status-error, status-some-errors）の条件確認
