---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：34-ワークフローパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **TraceableWorkflowのgetCalls()データ構造**：TraceableWorkflow.phpを直接確認しなかったため推定含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/workflow.html.twig`（テンプレート全文）
- E-02: `src/Symfony/Component/Workflow/DataCollector/WorkflowDataCollector.php`（データコレクター、行1-80）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.34行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.34行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コレクター名は"workflow" | E-02 行67-69 | ○ |
| C-02 | lateCollect()でworkflows配列構築 | E-02 行48-65 | ○ |
| C-03 | MermaidDumper(TRANSITION_TYPE_WORKFLOW)使用 | E-02 行58 | ○ |
| C-04 | Mermaid図のダークモード対応 | E-01 行138-157 | ○ |
| C-05 | ノードクリックでイベントリスナーダイアログ表示 | E-01 行160-164, 166-244 | ○ |
| C-06 | dialog要素でshowModal()使用 | E-01 行221, 241 | ○ |
| C-07 | ESCキー・Closeボタン・外部クリックでダイアログ閉じ | E-01 行225-239 | ○ |
| C-08 | タブ遅延Mermaidレンダリング | E-01 行248-264 | ○ |
| C-09 | Callsテーブルにmethod, args, return, exception, duration | E-01 行283-331 | ○ |
| C-10 | previousMarkingのprofiler_dump表示 | E-01 行300-304 | ○ |
| C-11 | returnがtrue/false/dumpの3パターン | E-01 行310-318 | ○ |
| C-12 | ワークフローなし時の空メッセージ | E-01 行131-134 | ○ |
| C-13 | メニューdisabled制御 | E-01 行120 | ○ |
| C-14 | ツールバーにcallsCount表示 | E-01 行103-106 | ○ |
| C-15 | Mermaid Liveリンク生成 | E-01 行280 | ○ |
| C-16 | ListenerExtractorでリスナー抽出 | E-02 行41, 62 | ○ |
| C-17 | ガード式の表示 | E-01 行197-213 | ○ |
| C-18 | LateDataCollectorInterface実装 | E-02 行32 | ○ |
| C-19 | Duration表示（ms、小数2桁） | E-01 行326 | ○ |
| C-20 | TraceableWorkflow::getCalls()からデータ取得 | E-02 行53 | △ |

## 4) 不足情報（Unknown / Missing）
- TraceableWorkflow.phpのgetCalls()戻り値の詳細構造が未検証
  - 候補：`src/Symfony/Component/Workflow/Debug/TraceableWorkflow.php`

## 5) リスクフラグ（レビュー観点）
- 0: TraceableWorkflowのcallsデータ構造はテンプレートの参照パターンから推定

## 6) レビュアーチェックリスト（最小）
- [ ] TraceableWorkflow.phpのgetCalls()の戻り値構造確認
- [ ] buildMermaidLiveLink()の生成URL形式確認
- [ ] ListenerExtractorが返すリスナーマップの構造確認
