---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-設定パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特に重点レビュー対象なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/config.html.twig`（テンプレート全文）
- E-02: `src/Symfony/Component/HttpKernel/DataCollector/ConfigDataCollector.php`（データコレクター、行1-80）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.35行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.35行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コレクター名は"config" | E-02（DataCollector標準命名規則） | ○ |
| C-02 | Symfonyバージョンを表示 | E-01 行71, 194, E-02 行48 | ○ |
| C-03 | LTS判定（MINOR_VERSION==4） | E-02 行50, E-01 行197 | ○ |
| C-04 | バージョン状態4種（dev/stable/eom/eol） | E-01 行218-219 | ○ |
| C-05 | ツールバーステータスカラー（eol=赤, eom/dev=黄） | E-01 行50-65, 169 | ○ |
| C-06 | 環境名・デバッグモード表示 | E-01 行102-114, E-02 行54-55 | ○ |
| C-07 | PHPバージョン情報 | E-01 行119-123, E-02 行56 | ○ |
| C-08 | PHP拡張機能（Xdebug/APCu/OPcache）の表示 | E-01 行127-139, E-02 行60-65 | ○ |
| C-09 | phpinfo()リンク | E-01 行122, 302 | ○ |
| C-10 | xdebug_info()リンク | E-01 行129-135, 290-296 | ○ |
| C-11 | Enabled Bundlesテーブル | E-01 行305-323, E-02 行71-75 | ○ |
| C-12 | Bundleのソート済み表示 | E-01 行315 | ○ |
| C-13 | ツールバー右端配置 | E-01 行169 | ○ |
| C-14 | Profiler token表示（リンク付き） | E-01 行86-93 | ○ |
| C-15 | Runnerクラス表示 | E-01 行95-100, 182-189 | ○ |
| C-16 | eom/eol期限日表示 | E-01 行230-248, E-02 行41-42 | ○ |
| C-17 | リリース詳細リンク | E-01 行250 | ○ |
| C-18 | Symfonyドキュメント・サポートリンク | E-01 行148-165 | ○ |
| C-19 | PHP SAPI表示 | E-01 行142-144, E-02 行67 | ○ |
| C-20 | アーキテクチャ（bits）表示 | E-01 行261, E-02 行57 | ○ |
| C-21 | Intlロケール表示 | E-01 行266, E-02 行58 | ○ |
| C-22 | タイムゾーン表示 | E-01 行271, E-02 行59 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全項目にソースコードレベルの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] determineSymfonyState()の状態判定ロジック（ConfigDataCollector後半部分）の確認
- [ ] lateCollect()でのrunnerClass判定ロジックの確認
