---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：36-コマンドパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **CliRequestの構造詳細**：CliRequest.phpを直接確認しなかったため推定含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Collector/command.html.twig`（テンプレート全文）
- E-02: `src/Symfony/Component/Console/DataCollector/CommandDataCollector.php`（データコレクター、行1-80）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.36行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.36行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは@WebProfiler/Collector/command.html.twig | E-01, E-03 | ○ |
| C-02 | CLIリクエスト以外ではデータ収集しない | E-02 行32-34 | ○ |
| C-03 | Duration/Peak Memory/Verbosity Levelメトリクス | E-01 行27-42, E-02 行43-52 | ○ |
| C-04 | Verbosity 6段階 | E-02 行45-52 | ○ |
| C-05 | Signalable/Interactive/Validate Input/Enabled/Visibleフラグ | E-01 行44-69, E-02 行53-56 | ○ |
| C-06 | Arguments/Optionsテーブル表示 | E-01 行71-89, E-02 行67-80 | ○ |
| C-07 | Interactive Inputs表示（Interactiveモード時のみ） | E-01 行91-105 | ○ |
| C-08 | Application inputs表示 | E-01 行107-115 | ○ |
| C-09 | Input/Outputタブでprofiler_dump表示 | E-01 行119-134 | ○ |
| C-10 | Helper Set一覧表示 | E-01 行136-161, E-02 行62 | ○ |
| C-11 | Server Parameters（.env/通常環境変数）表示 | E-01 行163-178 | ○ |
| C-12 | RequestDataCollectorのデータ参照 | E-01 行164 | ○ |
| C-13 | Signalsタブ（Signalable時のみ） | E-01 行180-217, E-02 行60-61 | ○ |
| C-14 | 親コマンドリンク | E-01 行219-232 | ○ |
| C-15 | サブコマンドリンク | E-01 行234-247 | ○ |
| C-16 | invokableCommandInfo優先表示 | E-01 行14-18, E-02 行40 | ○ |
| C-17 | 空メッセージ各種 | E-01 行74, 84, 99, 110, 140, 191 | ○ |
| C-18 | コマンドファイルリンク | E-01 行13 | ○ |
| C-19 | maxDepth:2でテーブル表示 | E-01 行78, 88, 103, 114 | ○ |
| C-20 | HandledSignals表示（signal, handled, duration, memory） | E-01 行194-213, E-02 行61 | ○ |
| C-21 | CliRequestのcommandプロパティ構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CliRequest.phpの内部構造（commandプロパティの詳細）が未検証
  - 候補：`src/Symfony/Component/Console/Debug/CliRequest.php`

## 5) リスクフラグ（レビュー観点）
- 0: CliRequestのcommandプロパティの構造はCommandDataCollectorの使用パターンから推定

## 6) レビュアーチェックリスト（最小）
- [ ] CliRequest.phpのcommandプロパティの型と構造確認
- [ ] コレクター名"command"の正確性確認（DataCollectorの命名規則準拠）
- [ ] invokableCommandInfoの設定条件確認
