---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：37-Dumpパネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **getDumps('html')の内部実装詳細**：DumpDataCollectorの後半部分を直接確認しなかったため推定含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/DebugBundle/Resources/views/Profiler/dump.html.twig`（テンプレート全文）
- E-02: `src/Symfony/Component/HttpKernel/DataCollector/DumpDataCollector.php`（データコレクター、行1-80）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.37行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.37行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは@Debug/Profiler/dump.html.twig | E-01, E-03 | ○ |
| C-02 | アイコンは@Debug/Profiler/icon.svg | E-01 行6, 41 | ○ |
| C-03 | dumpsCountでdump回数を取得 | E-01 行4 | ○ |
| C-04 | getDumps('html')でHTMLダンプ取得 | E-01 行11, 49 | ○ |
| C-05 | dump.label表示（存在する場合） | E-01 行14-16, 52-53 | ○ |
| C-06 | dump.file / dump.nameのリンクまたはabbr表示 | E-01 行17-26, 57-66 | ○ |
| C-07 | dump.lineの行番号表示 | E-01 行28, 67 | ○ |
| C-08 | dump.data|rawでHTMLダンプ表示 | E-01 行30, 76 | ○ |
| C-09 | ソースコード抜粋のトグル表示 | E-01 行70-74 | ○ |
| C-10 | dump0件時に"No content was dumped."表示 | E-01 行79-81 | ○ |
| C-11 | メニューdisabled（dump0件時） | E-01 行40 | ○ |
| C-12 | DataDumperInterface実装 | E-02 行32 | ○ |
| C-13 | dump(Data)でデータ収集 | E-02 行73-80 | ○ |
| C-14 | SourceContextProviderから呼び出し元情報取得 | E-02 行77 | ○ |
| C-15 | fileExcerptまたはfile_excerptフィルター使用 | E-01 行72 | ○ |
| C-16 | sf-dump sf-resetクラスで各dump表示 | E-01 行50 | ○ |
| C-17 | getDumps()の戻り値構造（name, file, line, fileExcerpt, data, label） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- getDumps()メソッドの完全な戻り値構造の確認が不足
  - 候補：DumpDataCollector.phpの後半部分を読み込んで確認

## 5) リスクフラグ（レビュー観点）
- 0: getDumps()の戻り値構造はテンプレートの参照パターンから推定

## 6) レビュアーチェックリスト（最小）
- [ ] getDumps('html')の戻り値配列の詳細構造確認
- [ ] Connection経由のdump送信とローカル収集の切替条件確認
- [ ] パネル名"dump"の正確性確認
