---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：38-例外詳細画面（開発環境）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **FlattenExceptionのデータ構造詳細**：FlattenException.phpを直接確認しなかったため推定含む

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/ErrorHandler/Resources/views/exception_full.html.php`（フルページテンプレート全文）
- E-02: `src/Symfony/Component/ErrorHandler/Resources/views/exception.html.php`（例外本体テンプレート全文）
- E-03: `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php`（レンダラー全文）
- E-04: `src/Symfony/Component/HttpKernel/Controller/ErrorController.php`（コントローラー全文）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧、No.38行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング、No.38行）
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートはexception_full.html.php（PHPテンプレート） | E-01, E-05 | ○ |
| C-02 | HtmlErrorRenderer::render()でFlattenException生成 | E-03 行62-73 | ○ |
| C-03 | renderException()でdebug判定 | E-03 行125-148 | ○ |
| C-04 | debug=trueでexception_full.html.php選択 | E-03 行140 | ○ |
| C-05 | ErrorController::__invoke()でResponse生成 | E-04 行35-40 | ○ |
| C-06 | X-Debug-Exceptionヘッダー付与 | E-03 行66 | ○ |
| C-07 | X-Debug-Exception-Fileヘッダー付与 | E-03 行67 | ○ |
| C-08 | Symfonyドキュメントリンク（ヘッダー） | E-01 行26 | ○ |
| C-09 | テーマ切替（localStorage/prefers-color-scheme） | E-01 行15-17 | ○ |
| C-10 | 例外クラス階層表示（チェブロン区切り） | E-02 行4-10 | ○ |
| C-11 | HTTPステータスコード・テキスト表示 | E-02 行11-13 | ○ |
| C-12 | 例外メッセージ（長文対応longクラス） | E-02 行18 | ○ |
| C-13 | ゴーストイラスト表示 | E-02 行21-22 | ○ |
| C-14 | Exceptionsタブ（traces.html.phpインクルード） | E-02 行29-62 | ○ |
| C-15 | ユーザーコード判定によるデフォルト展開 | E-02 行35-41, 57 | ○ |
| C-16 | Logsタブ（DebugLogger有効時のみ） | E-02 行64-81 | ○ |
| C-17 | Stack Tracesタブ（traces_text.html.php） | E-02 行83-103 | ○ |
| C-18 | Output contentタブ（出力バッファ有効時） | E-02 行105-113 | ○ |
| C-19 | ゴースト季節装飾（GHOST_ADDONS） | E-03 行27-31, 321-328 | ○ |
| C-20 | CSS/JSインライン | E-01 行10-11, 38 | ○ |
| C-21 | include()でob_start/ob_get_cleanレンダリング | E-03 行330-338 | ○ |
| C-22 | FlattenException::createWithDataRepresentation() | E-03 行70 | △ |

## 4) 不足情報（Unknown / Missing）
- FlattenException.phpの完全な構造（toArray(), getAllPrevious()等の詳細）が未検証
  - 候補：`src/Symfony/Component/ErrorHandler/Exception/FlattenException.php`

## 5) リスクフラグ（レビュー観点）
- 0: FlattenExceptionのメソッドはテンプレートの呼び出しから実在が確認できるが内部実装の詳細は未検証

## 6) レビュアーチェックリスト（最小）
- [ ] FlattenException.phpのtoArray()が返すスタックトレース構造の確認
- [ ] traces.html.phpのスタックトレース展開UIの詳細確認
- [ ] assets/css/exception.cssのダーク/ライトテーマCSS変数確認
