---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-プロファイラー検索バー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 191-218行目（searchBarActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/search.html.twig` 全体
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 21-23行目（_profiler_search_barルート）
- E-04: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/results.html.twig` 40行目（render controller呼び出し）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 13-15行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler_search_bar`である | E-03 | ○ |
| C-02 | URLパターンは`/search_bar`である | E-03 | ○ |
| C-03 | クエリパラメータ優先でセッション値がフォールバックとして使用される | E-01 (204行目等) | ○ |
| C-04 | profile_typeのデフォルト値は`request`でセッションキーは`_profiler_search_type` | E-01 (213行目) | ○ |
| C-05 | フォームのaction属性が`_profiler_search`ルートを指す | E-02 (2行目) | ○ |
| C-06 | requestタイプ時のラベルがIP/Method/Status/URLである | E-02 (8,20,43,56行目) | ○ |
| C-07 | commandタイプ時のラベルがApplication/Mode/Exit code/Commandである | E-02 (6,18,39,53行目) | ○ |
| C-08 | HTTPメソッドの選択肢がDELETE/GET/HEAD/PATCH/POST/PUT/QUERYである | E-02 (28行目) | ○ |
| C-09 | コマンドモードの選択肢がBATCH/INTERACTIVEである | E-02 (26行目) | ○ |
| C-10 | ステータスコードの範囲がmin=100, max=599（requestタイプ）である | E-02 (43行目) | ○ |
| C-11 | 終了コードの範囲がmin=0, max=255（commandタイプ）である | E-02 (40行目) | ○ |
| C-12 | 結果件数の選択肢が10/50/100である | E-02 (80行目) | ○ |
| C-13 | profile_typeがhiddenフィールドとして送信される | E-02 (86行目) | ○ |
| C-14 | 検索結果画面からrender(controller(...))で埋め込みレンダリングされる | E-04 | ○ |
| C-15 | CSPが無効化される | E-01 (195行目) | ○ |
| C-16 | _stateless属性がfalseかつセッション存在時のみセッションにアクセスする | E-01 (198行目) | ○ |
| C-17 | レスポンスのContent-Typeはtext/htmlである | E-01 (216行目) | ○ |
| C-18 | フォームはGETメソッドで送信される | E-02 (2行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートとコントローラーの対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] searchBarActionのフォールバック値取得ロジックが正確か確認
- [ ] search.html.twigのフォームフィールド定義が設計書と一致しているか確認
- [ ] profile_typeに応じたラベル切り替えが正確か確認
