---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-リダイレクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php` L1-187
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行43（No.42のエントリ）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行109-111（No.42の関連機能）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` セクション4（FrameworkBundle汎用コントローラー）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RedirectControllerはfinalクラスである | E-01 L28 | ○ |
| C-02 | コンストラクタでUrlGeneratorInterface、httpPort、httpsPortを受け取る | E-01 L30-35 | ○ |
| C-03 | redirectActionのパラメータ仕様 | E-01 L53 | ○ |
| C-04 | 空ルート名で410/404をスロー | E-01 L55-57 | ○ |
| C-05 | ignoreAttributes処理ロジック | E-01 L60-77 | ○ |
| C-06 | keepQueryParamsによるクエリパラメータ保持 | E-01 L63-71 | ○ |
| C-07 | ステータスコード決定マトリクス（301/302/307/308） | E-01 L79-83, L112-116 | ○ |
| C-08 | UrlGenerator::generateでURL生成 | E-01 L85 | ○ |
| C-09 | urlRedirectActionのパラメータ仕様 | E-01 L106 | ○ |
| C-10 | 空パスで410/404をスロー | E-01 L108-110 | ○ |
| C-11 | プロトコル相対URL（//始まり）の処理 | E-01 L120-122 | ○ |
| C-12 | 完全URL判定によるリダイレクト | E-01 L125-127 | ○ |
| C-13 | クエリストリング付加処理 | E-01 L129-135 | ○ |
| C-14 | ポート番号決定ロジック | E-01 L137-162 | ○ |
| C-15 | __invoke()によるroute/path振り分け | E-01 L169-186 | ○ |
| C-16 | route/path両方指定時のRuntimeException | E-01 L174-176 | ○ |
| C-17 | route/pathどちらも未指定時のRuntimeException | E-01 L185 | ○ |
| C-18 | 関連機能：FrameworkBundle、Routing、HttpFoundation | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RedirectControllerのソースコードは187行で全行を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ステータスコード決定マトリクス（301/302/307/308）が正確か確認
- [ ] urlRedirectActionのURL構築ロジックが正確に記述されているか確認
- [ ] ルーティング設定例がSymfony 8.1で動作するか確認
