---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：43-フォームレイアウト（div）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **TwigRendererEngineの型名ベースのブロック解決ルール**：コードリーディングガイド内の記述は推論に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` L1-482
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行44（No.43のエントリ）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行112-113（No.43の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | form_widgetブロックがcompound/simpleで振り分ける | E-01 L3-9 | ○ |
| C-02 | form_widget_simpleがinput要素を生成する | E-01 L11-18 | ○ |
| C-03 | form_widget_compoundがdiv要素で子要素をラップする | E-01 L20-28 | ○ |
| C-04 | choice_widgetがexpanded/collapsedで振り分ける | E-01 L41-47 | ○ |
| C-05 | choice_widget_collapsedがselect要素を生成しpreferred_choicesに対応 | E-01 L58-82 | ○ |
| C-06 | form_labelがlabel要素を生成し翻訳対応 | E-01 L267-305 | ○ |
| C-07 | form_helpがhelp-textクラスのdiv要素を生成 | E-01 L311-334 | ○ |
| C-08 | form_rowがaria-describedbyとaria-invalid属性を自動生成 | E-01 L346-363 | ○ |
| C-09 | form_row_renderがlabel + errors + widget + helpをdivでラップ | E-01 L365-372 | ○ |
| C-10 | form_errorsがul/li構造でエラーを表示 | E-01 L413-421 | ○ |
| C-11 | form_startがformタグと_methodフィールドを生成 | E-01 L392-404 | ○ |
| C-12 | form_endがform_restを呼び出しformタグを閉じる | E-01 L406-411 | ○ |
| C-13 | widget_attributesが共通属性（id, name, disabled, required）を出力 | E-01 L453-458 | ○ |
| C-14 | attributesブロックが任意のHTML属性を出力 | E-01 L470-481 | ○ |
| C-15 | 関連機能：Form（主機能）、Twig Bridge（主機能） | E-03 | ○ |
| C-16 | TwigRendererEngineの型名ベースブロック解決ルール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: TwigRendererEngineの具体的なブロック解決アルゴリズムはソースコードを直接確認していない
  - 候補：TwigRendererEngine.php / FormRenderer.php / Symfonyフォームドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートファイルの全ブロックを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 定義されているTwigブロック一覧が網羅的か確認
- [ ] 各ブロックの出力HTML構造が正確か確認
- [ ] form_row_renderのHTML構造（label→errors→widget→helpの順序）が正確か確認
