---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-フォームレイアウト（table）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/form_table_layout.html.twig` L1-47
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` L1-482
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行45（No.44のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行114-115（No.44の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | form_div_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | form_row_renderがtr/td構造で出力 | E-01 L3-14 | ○ |
| C-03 | button_rowが左列空セル、右列ボタン | E-01 L16-23 | ○ |
| C-04 | hidden_rowがdisplay:noneスタイル付きtr/td | E-01 L25-32 | ○ |
| C-05 | form_widget_compoundがtable要素でラップ | E-01 L34-46 | ○ |
| C-06 | ルートフォームのエラーがcolspan=2のtr/tdに配置 | E-01 L36-42 | ○ |
| C-07 | テーブルレイアウトは4ブロックのオーバーライドのみ | E-01（全47行で4ブロック） | ○ |
| C-08 | hidden_rowでrow_attr.styleを考慮 | E-01 L26 | ○ |
| C-09 | 関連機能：Form、Twig Bridge | E-04 | ○ |
| C-10 | テンプレートファイルパスが正確 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 47行の小規模テンプレートで全行を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 4つのオーバーライドブロックのHTML構造が正確か確認
- [ ] form_div_layoutから継承されるブロックの一覧が正しいか確認
