---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-プロファイラー検索結果

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 225-257行目（searchResultsActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/results.html.twig` 全体
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 33-35行目（_profiler_search_resultsルート）
- E-04: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/layout.html.twig` 全体
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` 25行目、28-29行目
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 16-18行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler_search_results`、URLパターンは`/{token}/search/results` | E-03 | ○ |
| C-02 | searchResultsActionが9つの検索パラメータを受け取る | E-01 (233-240行目) | ○ |
| C-03 | Profiler::loadProfile()でトークンのプロファイルを読み込む | E-01 (231行目) | ○ |
| C-04 | Profiler::find()で検索実行する | E-01 (246行目) | ○ |
| C-05 | virtual_typeフィルタリングコールバックが使用される | E-01 (246行目) | ○ |
| C-06 | profile_typeのデフォルトは'request' | E-01 (240行目) | ○ |
| C-07 | HTTP Requests/Console Commandsのタブ切り替えがある | E-02 (44-57行目) | ○ |
| C-08 | 結果テーブルに6カラム（Status, IP, Method, URL, Time, Token）がある | E-02 (64-95行目) | ○ |
| C-09 | requestタイプのステータスコード色分け: >399=error, >299=warning, else=success | E-02 (102行目) | ○ |
| C-10 | commandタイプの終了コード色分け: 113=warning, >0=error, else=success | E-02 (100行目) | ○ |
| C-11 | フィルター検索リンク（profile_search_filterマクロ）がIP/Method/URL列に付与される | E-02 (3-7行目, 110行目, 113行目, 117行目) | ○ |
| C-12 | フィルターリンクはホバー時のみ表示される | E-02 (19-24行目のCSS) | ○ |
| C-13 | 日時表示にdata-convert-to-user-timezone属性が使用される | E-02 (120行目, 123行目) | ○ |
| C-14 | トークンリンクが_profilerルートを指す | E-02 (127行目) | ○ |
| C-15 | 検索結果が空の場合「The query returned no result.」が表示される | E-02 (134行目) | ○ |
| C-16 | layout.html.twigを継承している | E-02 (1行目) | ○ |
| C-17 | サイドバーにsearchBarActionが埋め込みレンダリングされる | E-02 (40行目) | ○ |
| C-18 | サマリー領域に「Profile Search」が表示される | E-02 (32-35行目) | ○ |
| C-19 | 画面遷移図でHOME/SEARCHからSEARCH_RESULTSへの遷移が定義されている | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートとコントローラーの対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] searchResultsActionの処理フローが設計書と一致しているか確認
- [ ] テーブルのカラム構成とラベル切り替えが正確か確認
- [ ] ステータスコードの色分けルールが正確か確認
- [ ] フィルター検索リンクの動作が正しく記述されているか確認
