---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-プロファイラー情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 79-81行目（panelAction内のinfo表示分岐）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/info.html.twig` 全体
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` 30行目（PANEL→INFOの遷移）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 19-20行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | panelAction内でloadProfile失敗時にinfo.html.twigが表示される | E-01 | ○ |
| C-02 | about='no_token'パラメータが渡される | E-01 (80行目) | ○ |
| C-03 | layout.html.twigを継承している | E-02 (1行目) | ○ |
| C-04 | messages変数が連想配列でメッセージを定義している | E-02 (3-9行目) | ○ |
| C-05 | latestトークン時のタイトルは「There are no profiles」 | E-02 (6行目) | ○ |
| C-06 | latestトークン時のメッセージは「No profiles found.」 | E-02 (7行目) | ○ |
| C-07 | その他トークン時のタイトルは「Token not found」 | E-02 (6行目) | ○ |
| C-08 | その他トークン時のメッセージは「Token "{token}" not found.」 | E-02 (7行目) | ○ |
| C-09 | ステータスは'error'である | E-02 (5行目) | ○ |
| C-10 | サマリー領域にstatus-errorクラスが適用される | E-02 (12行目) | ○ |
| C-11 | パネル領域にタイトル（h2）とメッセージ（p）が表示される | E-02 (20-21行目) | ○ |
| C-12 | token, request, profile_typeがテンプレート変数として渡される | E-01 (80行目) | ○ |
| C-13 | 画面遷移図でPANEL→INFOの遷移が「トークン不明」条件で定義されている | E-03 | ○ |
| C-14 | 画面機能マッピングでWebProfilerBundleとTwigBundleが関連付けられている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートが単純で検証容易

## 6) レビュアーチェックリスト（最小）
- [ ] info.html.twigのメッセージ定義が設計書と一致しているか確認
- [ ] panelActionのフォールバック分岐が正しく記述されているか確認
