---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ソースファイル表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 378-400行目（openActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Resources/views/Profiler/open.html.twig` 全体
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 36-38行目（_profiler_open_fileルート）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 31行目（PANEL→OPEN_FILEの遷移）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 21-23行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler_open_file`、URLパターンは`/open` | E-03 | ○ |
| C-02 | baseDirがnullの場合NotFoundHttpExceptionをスロー | E-01 (380-382行目) | ○ |
| C-03 | プロファイラー計測を無効化する | E-01 (384行目) | ○ |
| C-04 | file, lineクエリパラメータを取得する | E-01 (386-387行目) | ○ |
| C-05 | baseDir + DIRECTORY_SEPARATOR + fileでフルパスを構築する | E-01 (389行目) | ○ |
| C-06 | ドットコンポーネントを含むパスをpreg_matchで排除する | E-01 (391行目) | ○ |
| C-07 | ファイルが読み取り不可の場合NotFoundHttpExceptionをスロー | E-01 (391-393行目) | ○ |
| C-08 | SplFileInfoオブジェクトを生成する | E-01 (396行目) | ○ |
| C-09 | base.html.twigを直接継承している（layout.html.twigではない） | E-02 (1行目) | ○ |
| C-10 | file_excerptフィルターでファイル内容をHTML化する | E-02 (14行目) | ○ |
| C-11 | 指定行がある場合「line {line}」が表示される | E-02 (18行目) | ○ |
| C-12 | ファイルが読み取れない場合「The file is not readable.」が表示される | E-02 (22行目) | ○ |
| C-13 | サイドバーにFilepath, Last modified, Sizeが表示される | E-02 (31-44行目) | ○ |
| C-14 | IDE連携のドキュメントリンクが表示される | E-02 (46行目) | ○ |
| C-15 | ファイルサイズが1KB未満はバイト、1KB以上はKBで表示される | E-02 (41行目) | ○ |
| C-16 | JavaScriptで指定行への自動スクロールが実行される | E-02 (52-63行目) | ○ |
| C-17 | スクロールは上部20pxオフセットのスムーズスクロール | E-02 (61行目) | ○ |
| C-18 | 画面遷移図でPANEL→OPEN_FILEの遷移が定義されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティチェックの実装も明確

## 6) レビュアーチェックリスト（最小）
- [ ] openActionのセキュリティバリデーション（パストラバーサル防止）が正確か確認
- [ ] open.html.twigのレイアウト構造とメタデータ表示が設計書と一致しているか確認
- [ ] 自動スクロールJavaScriptの動作が正しく記述されているか確認
