---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-PHP情報表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 316-327行目（phpinfoActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 410-417行目（denyAccessIfProfilerDisabledメソッド）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 24-26行目（_profiler_phpinfoルート）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 33行目（PANEL→PHPINFOの遷移）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 24-25行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler_phpinfo`、URLパターンは`/phpinfo` | E-03 | ○ |
| C-02 | コントローラーは`web_profiler.controller.profiler::phpinfoAction` | E-03 | ○ |
| C-03 | プロファイラー有効性を確認する | E-01 (318行目), E-02 | ○ |
| C-04 | CSPを無効化する | E-01 (320行目) | ○ |
| C-05 | ob_start()で出力バッファリングを開始する | E-01 (322行目) | ○ |
| C-06 | phpinfo()を実行する | E-01 (323行目) | ○ |
| C-07 | ob_get_clean()でバッファ内容を取得する | E-01 (324行目) | ○ |
| C-08 | HTTP 200ステータスコードでレスポンスを返却する | E-01 (326行目) | ○ |
| C-09 | Content-Typeはtext/htmlである | E-01 (326行目) | ○ |
| C-10 | プロファイラー無効時はNotFoundHttpExceptionがスローされる | E-02 | ○ |
| C-11 | テンプレートを使用せずphpinfo()出力をそのまま返却する | E-01 (326行目) | ○ |
| C-12 | 画面遷移図でPANEL→PHPINFOの遷移が定義されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな処理で検証容易

## 6) レビュアーチェックリスト（最小）
- [ ] phpinfoActionメソッドの処理フローが設計書と一致しているか確認
- [ ] 出力バッファリングパターン（ob_start/ob_get_clean）が正確か確認
