---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Xdebug情報表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 334-349行目（xdebugActionメソッド）
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` 410-417行目（denyAccessIfProfilerDisabledメソッド）
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Resources/config/routing/profiler.php` 27-29行目（_profiler_xdebugルート）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` 34行目（PANEL→XDEBUGの遷移）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 26-27行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルート名は`_profiler_xdebug`、URLパターンは`/xdebug` | E-03 | ○ |
| C-02 | コントローラーは`web_profiler.controller.profiler::xdebugAction` | E-03 | ○ |
| C-03 | プロファイラー有効性を確認する | E-01 (336行目), E-02 | ○ |
| C-04 | function_exists('xdebug_info')でXdebug 3の存在を確認する | E-01 (338行目) | ○ |
| C-05 | Xdebug未インストール時のエラーメッセージは'Xdebug must be installed in version 3.' | E-01 (339行目) | ○ |
| C-06 | CSPを無効化する | E-01 (342行目) | ○ |
| C-07 | ob_start()で出力バッファリングを開始する | E-01 (344行目) | ○ |
| C-08 | xdebug_info()を実行する | E-01 (345行目) | ○ |
| C-09 | ob_get_clean()でバッファ内容を取得する | E-01 (346行目) | ○ |
| C-10 | HTTP 200ステータスコードでレスポンスを返却する | E-01 (348行目) | ○ |
| C-11 | Content-Typeはtext/htmlである | E-01 (348行目) | ○ |
| C-12 | プロファイラー無効時はNotFoundHttpExceptionがスローされる | E-02 | ○ |
| C-13 | Xdebug未インストール時はNotFoundHttpExceptionがスローされる | E-01 (339行目) | ○ |
| C-14 | 画面遷移図でPANEL→XDEBUGの遷移が定義されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな処理で検証容易

## 6) レビュアーチェックリスト（最小）
- [ ] xdebugActionメソッドの処理フローが設計書と一致しているか確認
- [ ] Xdebug存在確認の実装が正確か確認
