---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 54
  claims_without_evidence: 6
confidence_derived: 0.90
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：54 / 60、根拠なし：6
- 優先レビュー（高）
  1. **IT-035 FailoverTransport連携**：FailoverTransport内部実装の詳細未確認
  2. **IT-036 RoundRobinTransport連携**：RoundRobinTransport内部実装の詳細未確認
  3. **IT-042 PdoAdapter連携**：PdoAdapterの実装詳細を直接読み込んでいない
  4. **IT-044 MemcachedAdapter連携**：MemcachedAdapterの実装詳細を直接読み込んでいない
  5. **IT-055 EventSourceHttpClient連携**：EventSourceHttpClientの実装詳細を直接読み込んでいない
  6. **IT-057 HttpCache連携**：HttpCache内部実装の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/HttpKernel/HttpKernel.php` - HttpKernelクラス（handleRaw, handleThrowable, terminate, filterResponse）
- E-02: `src/Symfony/Component/HttpKernel/HttpClientKernel.php` - HttpClientKernelクラス（handle, getBody, getHeaders）
- E-03: `src/Symfony/Component/HttpKernel/EventListener/RouterListener.php` - RouterListenerクラス（onKernelRequest, onKernelFinishRequest）
- E-04: `src/Symfony/Component/Security/Http/Firewall.php` - Firewallクラス（onKernelRequest, onKernelFinishRequest, callListeners）
- E-05: `src/Symfony/Component/Security/Http/Authenticator/JsonLoginAuthenticator.php` - JsonLoginAuthenticatorクラス（supports, authenticate, onAuthenticationFailure）
- E-06: `src/Symfony/Component/Security/Http/Authenticator/AccessTokenAuthenticator.php` - AccessTokenAuthenticatorクラス（supports, authenticate, onAuthenticationFailure）
- E-07: `src/Symfony/Component/Mailer/Mailer.php` - Mailerクラス（send）
- E-08: `src/Symfony/Component/Messenger/MessageBus.php` - MessageBusクラス（dispatch）
- E-09: `src/Symfony/Component/Messenger/Middleware/SendMessageMiddleware.php` - SendMessageMiddlewareクラス（handle）
- E-10: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineTransactionMiddleware.php` - DoctrineTransactionMiddlewareクラス（handleForManager）
- E-11: `src/Symfony/Component/Notifier/Notifier.php` - Notifierクラス（send, getChannels）
- E-12: `src/Symfony/Component/Notifier/Channel/EmailChannel.php` - EmailChannelクラス（notify, supports）
- E-13: `src/Symfony/Component/Notifier/Channel/ChatChannel.php` - ChatChannelクラス（notify, supports）
- E-14: `src/Symfony/Component/Notifier/Channel/SmsChannel.php` - SmsChannelクラス（notify, supports）
- E-15: `src/Symfony/Component/Notifier/Chatter.php` - Chatterクラス（send, supports）
- E-16: `src/Symfony/Component/Webhook/Controller/WebhookController.php` - WebhookControllerクラス（handle）
- E-17: `src/Symfony/Component/HttpKernel/HttpKernelBrowser.php` - HttpKernelBrowserクラス（doRequest, filterRequest, filterResponse）
- E-18: `src/Symfony/Component/Mailer/Transport/Smtp/SmtpTransport.php` - SmtpTransportクラス
- E-19: `src/Symfony/Component/Scheduler/Scheduler.php` - Schedulerクラス（run, stop, addSchedule）
- E-20: `src/Symfony/Component/Cache/Adapter/` - キャッシュアダプター一覧（DoctrineDbalAdapter, PdoAdapter, RedisAdapter, MemcachedAdapter, ChainAdapter）
- E-21: `src/Symfony/Component/HttpClient/` - HttpClientコンポーネント（CurlHttpClient, RetryableHttpClient, CachingHttpClient, EventSourceHttpClient, NoPrivateNetworkHttpClient）
- E-22: `src/Symfony/Component/Messenger/Middleware/ValidationMiddleware.php` - ValidationMiddleware
- E-23: `src/Symfony/Component/Messenger/Middleware/HandleMessageMiddleware.php` - HandleMessageMiddleware
- E-24: `src/Symfony/Component/Messenger/Middleware/DispatchAfterCurrentBusMiddleware.php` - DispatchAfterCurrentBusMiddleware
- E-25: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineClearEntityManagerWorkerSubscriber.php` - DoctrineClearEntityManagerWorkerSubscriber
- E-26: `src/Symfony/Bridge/Doctrine/Messenger/DoctrinePingConnectionMiddleware.php` - DoctrinePingConnectionMiddleware
- E-27: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineCloseConnectionMiddleware.php` - DoctrineCloseConnectionMiddleware
- E-28: `src/Symfony/Component/HttpKernel/EventListener/ErrorListener.php` - ErrorListener
- E-29: `src/Symfony/Component/HttpKernel/EventListener/SessionListener.php` - SessionListener
- E-30: `src/Symfony/Component/HttpKernel/EventListener/FragmentListener.php` - FragmentListener
- E-31: `src/Symfony/Component/HttpKernel/HttpCache/HttpCache.php` - HttpCacheクラス
- E-32: `src/Symfony/Component/Mailer/Transport/FailoverTransport.php` - FailoverTransport
- E-33: `src/Symfony/Component/Mailer/Transport/RoundRobinTransport.php` - RoundRobinTransport

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: HttpKernelのリクエスト処理パイプライン | E-01 | ○ |
| C-02 | IT-002: HttpKernelの例外処理連携 | E-01 | ○ |
| C-03 | IT-003: HttpKernelのTerminate処理 | E-01 | ○ |
| C-04 | IT-004: RouterListenerのルーティング連携 | E-03 | ○ |
| C-05 | IT-005: RouterListenerのルート不一致エラー | E-03 | ○ |
| C-06 | IT-006: RouterListenerのHTTPメソッド不一致 | E-03 | ○ |
| C-07 | IT-007: HttpClientKernelの外部HTTP連携 | E-02 | ○ |
| C-08 | IT-008: HttpClientKernelのファイルアップロード連携 | E-02 | ○ |
| C-09 | IT-009: Firewallのセキュリティ認証連携 | E-04 | ○ |
| C-10 | IT-010: FirewallのExceptionListener登録連携 | E-04 | ○ |
| C-11 | IT-011: JsonLoginAuthenticatorのJSON認証連携 | E-05 | ○ |
| C-12 | IT-012: JsonLoginAuthenticatorの認証失敗レスポンス | E-05 | ○ |
| C-13 | IT-013: AccessTokenAuthenticatorのトークン認証連携 | E-06 | ○ |
| C-14 | IT-014: AccessTokenAuthenticatorのトークン不正時レスポンス | E-06 | ○ |
| C-15 | IT-015: Mailerの同期送信連携 | E-07 | ○ |
| C-16 | IT-016: MailerのMessenger統合非同期送信 | E-07 | ○ |
| C-17 | IT-017: MailerのMessageEventイベント連携 | E-07 | ○ |
| C-18 | IT-018: MailerのHandlerFailedException伝播 | E-07 | ○ |
| C-19 | IT-019: MessageBusのミドルウェアチェーン連携 | E-08 | ○ |
| C-20 | IT-020: SendMessageMiddlewareのトランスポート送信連携 | E-09 | ○ |
| C-21 | IT-021: SendMessageMiddlewareの受信メッセージスキップ | E-09 | ○ |
| C-22 | IT-022: DoctrineTransactionMiddlewareのトランザクション連携 | E-10 | ○ |
| C-23 | IT-023: DoctrineTransactionMiddlewareのロールバック連携 | E-10 | ○ |
| C-24 | IT-024: Notifierの通知チャネル連携 | E-11 | ○ |
| C-25 | IT-025: EmailChannelのメール通知連携 | E-12 | ○ |
| C-26 | IT-026: EmailChannelのFrom未設定エラー | E-12 | ○ |
| C-27 | IT-027: ChatChannelのチャット通知連携 | E-13 | ○ |
| C-28 | IT-028: SmsChannelのSMS通知連携 | E-14 | ○ |
| C-29 | IT-029: ChatterのMessenger統合チャット送信 | E-15 | ○ |
| C-30 | IT-030: WebhookControllerのWebhook受信処理連携 | E-16 | ○ |
| C-31 | IT-031: WebhookControllerの未登録タイプエラー | E-16 | ○ |
| C-32 | IT-032: WebhookControllerのパース失敗レスポンス | E-16 | ○ |
| C-33 | IT-033: HttpKernelBrowserのブラウザテスト連携 | E-17 | ○ |
| C-34 | IT-034: SmtpTransportのSMTP送信連携 | E-18 | ○ |
| C-35 | IT-035: FailoverTransport連携 | E-32 | △ |
| C-36 | IT-036: RoundRobinTransport連携 | E-33 | △ |
| C-37 | IT-037: Schedulerのメッセージスケジュール実行連携 | E-19 | ○ |
| C-38 | IT-038: SchedulerのPreRun/PostRunイベント連携 | E-19 | ○ |
| C-39 | IT-039: SchedulerのFailureEvent連携 | E-19 | ○ |
| C-40 | IT-040: SchedulerのPreRunEventキャンセル連携 | E-19 | ○ |
| C-41 | IT-041: DoctrineDbalAdapterのキャッシュDB連携 | E-20 | ○ |
| C-42 | IT-042: PdoAdapterのPDOキャッシュ連携 | E-20 | △ |
| C-43 | IT-043: RedisAdapterのRedisキャッシュ連携 | E-20 | ○ |
| C-44 | IT-044: MemcachedAdapterのMemcachedキャッシュ連携 | E-20 | △ |
| C-45 | IT-045: ChainAdapterのキャッシュチェーン連携 | E-20 | ○ |
| C-46 | IT-046: CurlHttpClientのcURL HTTP連携 | E-21 | ○ |
| C-47 | IT-047: RetryableHttpClientのHTTPリトライ連携 | E-21 | ○ |
| C-48 | IT-048: CachingHttpClientのHTTPキャッシュ連携 | E-21 | ○ |
| C-49 | IT-049: ValidationMiddlewareのMessengerバリデーション連携 | E-22 | ○ |
| C-50 | IT-050: HandleMessageMiddlewareのハンドラ実行連携 | E-23 | ○ |
| C-51 | IT-051: DispatchAfterCurrentBusMiddlewareの遅延ディスパッチ連携 | E-24 | ○ |
| C-52 | IT-052: DoctrineClearEntityManagerWorkerSubscriberのWorker連携 | E-25 | ○ |
| C-53 | IT-053: DoctrinePingConnectionMiddlewareのDB接続チェック連携 | E-26 | ○ |
| C-54 | IT-054: DoctrineCloseConnectionMiddlewareのDB接続クローズ連携 | E-27 | ○ |
| C-55 | IT-055: EventSourceHttpClientのSSE連携 | E-21 | △ |
| C-56 | IT-056: NoPrivateNetworkHttpClientのプライベートネットワーク制限連携 | E-21 | ○ |
| C-57 | IT-057: HttpCacheのHTTPキャッシュプロキシ連携 | E-31 | △ |
| C-58 | IT-058: ErrorListenerのエラーレスポンス連携 | E-28 | ○ |
| C-59 | IT-059: SessionListenerのセッション連携 | E-29 | ○ |
| C-60 | IT-060: FragmentListenerのサブリクエスト連携 | E-30 | ○ |

## 4) 不足情報（Unknown / Missing）
- IT-035/IT-036（FailoverTransport/RoundRobinTransport）：ファイルの存在は確認したが、内部実装の詳細（フェイルオーバー条件、ラウンドロビンアルゴリズム）を直接読み込んでいない
  - 候補：`src/Symfony/Component/Mailer/Transport/FailoverTransport.php` / `src/Symfony/Component/Mailer/Transport/RoundRobinTransport.php` の詳細読み込み
- IT-042（PdoAdapter）：ファイルの存在はアダプター一覧で確認したが、PdoAdapter固有の実装詳細を直接読み込んでいない
  - 候補：`src/Symfony/Component/Cache/Adapter/PdoAdapter.php` の詳細読み込み
- IT-044（MemcachedAdapter）：ファイルの存在はアダプター一覧で確認したが、Memcached固有の実装詳細を直接読み込んでいない
  - 候補：`src/Symfony/Component/Cache/Adapter/MemcachedAdapter.php` の詳細読み込み
- IT-055（EventSourceHttpClient）：ファイルの存在はHttpClientディレクトリ一覧で確認したが、SSE処理の内部実装を直接読み込んでいない
  - 候補：`src/Symfony/Component/HttpClient/EventSourceHttpClient.php` の詳細読み込み
- IT-057（HttpCache）：ファイルの存在はHttpCacheディレクトリ一覧で確認したが、キャッシュプロキシの内部実装を直接読み込んでいない
  - 候補：`src/Symfony/Component/HttpKernel/HttpCache/HttpCache.php` の詳細読み込み

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - IT-001〜IT-034, IT-037〜IT-041, IT-043, IT-045〜IT-054, IT-056, IT-058〜IT-060：ソースコードを直接読み込んで確認済み
- **1: 中リスク** - IT-035, IT-036, IT-042, IT-044, IT-055, IT-057：ファイルの存在は確認済みだが内部実装の詳細を直接確認していない。テストケースの記述はコンポーネントの一般的な動作に基づく
- **2: 高リスク** - 該当なし

## 6) レビュアーチェックリスト（最小）
- [ ] テスト種別（API連携/コンポーネント間連携/データベース連携/外部サービス連携）の分類が適切か
- [ ] 各テストケースの前提条件がプロジェクトの実際の設定と一致しているか
- [ ] 期待結果がソースコードの実際の挙動と整合しているか
- [ ] IT-035, IT-036のFailover/RoundRobin連携のテスト手順が内部実装と一致しているか
- [ ] IT-042, IT-044のPdo/Memcachedアダプターのテストケースが実装と一致しているか
- [ ] IT-055のEventSourceHttpClientのSSE連携テストケースが実装と一致しているか
- [ ] IT-057のHttpCacheのキャッシュプロキシ連携テストケースが実装と一致しているか
- [ ] 優先度（高/中/低）の設定が適切か
- [ ] プロジェクト固有の設定・環境に依存するテスト条件が漏れていないか
- [ ] Symfony 8.1固有の新機能に関する結合テストが網羅されているか
