---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全ての主張にソースコード上の根拠が存在
  2. **サードパーティBridge通知の網羅性**：Notifier Bridgeコンポーネント（Slack, Telegram等）は本リポジトリには含まれていないため通知一覧の対象外としている
  3. **カスタム通知実装の可能性**：フレームワーク利用者が独自に実装する通知クラスは対象外としている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Notifier/Notification/EmailNotificationInterface.php`
- E-02: `src/Symfony/Component/Notifier/Channel/EmailChannel.php`
- E-03: `src/Symfony/Component/Notifier/Notification/SmsNotificationInterface.php`
- E-04: `src/Symfony/Component/Notifier/Channel/SmsChannel.php`
- E-05: `src/Symfony/Component/Notifier/Notification/ChatNotificationInterface.php`
- E-06: `src/Symfony/Component/Notifier/Channel/ChatChannel.php`
- E-07: `src/Symfony/Component/Notifier/Notification/PushNotificationInterface.php`
- E-08: `src/Symfony/Component/Notifier/Channel/PushChannel.php`
- E-09: `src/Symfony/Component/Notifier/Notification/DesktopNotificationInterface.php`
- E-10: `src/Symfony/Component/Notifier/Channel/DesktopChannel.php`
- E-11: `src/Symfony/Component/Notifier/Channel/BrowserChannel.php`
- E-12: `src/Symfony/Component/Notifier/FlashMessage/DefaultFlashMessageImportanceMapper.php`
- E-13: `src/Symfony/Component/Notifier/FlashMessage/BootstrapFlashMessageImportanceMapper.php`
- E-14: `src/Symfony/Component/Notifier/Notification/Notification.php`
- E-15: `src/Symfony/Component/Notifier/EventListener/SendFailedMessageToNotifierListener.php`
- E-16: `src/Symfony/Component/Notifier/Event/MessageEvent.php`
- E-17: `src/Symfony/Component/Notifier/Event/SentMessageEvent.php`
- E-18: `src/Symfony/Component/Notifier/Event/FailedMessageEvent.php`
- E-19: `src/Symfony/Component/Mailer/Event/MessageEvent.php`
- E-20: `src/Symfony/Component/Mailer/Event/SentMessageEvent.php`
- E-21: `src/Symfony/Component/Mailer/Event/FailedMessageEvent.php`
- E-22: `src/Symfony/Component/RemoteEvent/Event/Mailer/MailerDeliveryEvent.php`
- E-23: `src/Symfony/Component/RemoteEvent/Event/Mailer/MailerEngagementEvent.php`
- E-24: `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php`
- E-25: `src/Symfony/Component/Notifier/EventListener/NotificationLoggerListener.php`
- E-26: `src/Symfony/Component/Notifier/Notifier.php`
- E-27: `src/Symfony/Component/Notifier/Channel/ChannelPolicy.php`
- E-28: `src/Symfony/Component/Notifier/Message/EmailMessage.php`
- E-29: `src/Symfony/Component/Notifier/Message/SmsMessage.php`
- E-30: `src/Symfony/Component/Notifier/Message/ChatMessage.php`
- E-31: `src/Symfony/Component/Notifier/Message/PushMessage.php`
- E-32: `src/Symfony/Component/Notifier/Message/DesktopMessage.php`
- E-33: `src/Symfony/Component/RemoteEvent/Event/Mailer/AbstractMailerEvent.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EmailNotification: EmailNotificationInterfaceを実装した通知でEmailChannelを通じてメール送信 | E-01, E-02, E-28 | ○ |
| C-02 | SmsNotification: SmsNotificationInterfaceを実装した通知でSmsChannelを通じてSMS送信 | E-03, E-04, E-29 | ○ |
| C-03 | ChatNotification: ChatNotificationInterfaceを実装した通知でChatChannelを通じてチャットメッセージ送信 | E-05, E-06, E-30 | ○ |
| C-04 | PushNotification: PushNotificationInterfaceを実装した通知でPushChannelを通じてプッシュ通知送信 | E-07, E-08, E-31 | ○ |
| C-05 | DesktopNotification: DesktopNotificationInterfaceを実装した通知でDesktopChannelを通じてデスクトップ通知送信 | E-09, E-10, E-32 | ○ |
| C-06 | BrowserFlashMessage: BrowserChannelでセッションにフラッシュメッセージを追加。重要度マッピングをサポート | E-11, E-12, E-13 | ○ |
| C-07 | ExceptionNotification: Notification::fromThrowable()で例外から通知を自動生成 | E-14 | ○ |
| C-08 | SendFailedMessageToNotifier: Messengerワーカー失敗時に管理者へ通知送信。重要度HIGH。リトライ時は通知しない | E-15 | ○ |
| C-09 | MessageEvent（Notifier）: 通知メッセージ送信時に発火するイベント | E-16 | ○ |
| C-10 | SentMessageEvent（Notifier）: 通知メッセージ送信完了時に発火するイベント | E-17 | ○ |
| C-11 | FailedMessageEvent（Notifier）: 通知メッセージ送信失敗時に発火するイベント | E-18 | ○ |
| C-12 | MessageEvent（Mailer）: メール送信前に発火。reject()で送信拒否可能 | E-19 | ○ |
| C-13 | SentMessageEvent（Mailer）: メール送信完了後に発火するイベント | E-20 | ○ |
| C-14 | FailedMessageEvent（Mailer）: メール送信失敗時に発火するイベント | E-21 | ○ |
| C-15 | MailerDeliveryEvent: メール配信状態追跡（received/dropped/delivered/deferred/bounce）。reason保持可能 | E-22, E-33 | ○ |
| C-16 | MailerEngagementEvent: メールエンゲージメント追跡（open/click/spam/unsubscribe） | E-23, E-33 | ○ |
| C-17 | NotificationEmail: Twigテンプレートベースの通知メール。重要度に応じた件名プレフィックスと優先度設定。Markdown対応。例外添付。テーマ切替対応 | E-24 | ○ |
| C-18 | NotificationLoggerListener: 通知メッセージイベントをログ記録するリスナー | E-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本リポジトリにはNotifier Bridgeコンポーネント（Slack, Telegram, Discord等のサードパーティ連携）が含まれていないため、それらの通知種別は一覧に含まれていない
  - 候補：symfony/slack-notifier / symfony/telegram-notifier / symfony/discord-notifier 等の個別パッケージ
- Webhookコンポーネント（src/Symfony/Component/Webhook）が存在するが、直接的な通知インターフェースではないため一覧対象外とした
  - 候補：Webhook経由の通知パターンがある場合は追加を検討

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード上の直接的な根拠が存在
- 0: 低リスク - NotifierおよびMailerコンポーネントの通知チャネル・メッセージタイプ・イベントを網羅的に抽出済み
- 1: 中リスク - サードパーティBridge通知（Slack, Telegram等）の個別パッケージが本リポジトリに含まれていないため、完全な通知種別の網羅は保証できない

## 6) レビュアーチェックリスト（最小）
- [ ] 各通知チャネル（Email/SMS/Chat/Push/Desktop/Browser）の説明がソースコードの実装と一致しているか
- [ ] SendFailedMessageToNotifierListenerのリトライ時非通知の記述が正しいか（E-15のwillRetry()確認）
- [ ] MailerDeliveryEventの状態一覧（5種）が定数定義と一致しているか
- [ ] MailerEngagementEventの状態一覧（4種）が定数定義と一致しているか
- [ ] NotificationEmailの重要度マッピング（urgent->HIGHEST, high->HIGH, medium->NORMAL, low->LOW）が正しいか
- [ ] サードパーティBridge通知の不在が許容されるか（プロジェクト方針に依存）
