# 通知設計書 2-SmsNotification

## 概要

本ドキュメントは、Symfony NotifierコンポーネントにおけるSMS通知（SmsNotification）の設計仕様を記述する。SmsNotificationInterfaceを実装した通知オブジェクトがSmsChannelを通じてSMSメッセージを送信する仕組みについて、送信フロー・メッセージ構成・エラー処理等の観点から詳細に定義する。

### 本通知の処理概要

SmsNotificationは、Symfony Notifierコンポーネントが提供するSMS送信チャネルを通じた通知機能である。NotificationオブジェクトにSmsNotificationInterfaceを実装することで、カスタムSMSメッセージの生成が可能となり、SmsChannelがそのメッセージをNotifier Transport（Twilio、Vonage等）またはSymfony Messenger経由で送信する。

**業務上の目的・背景**：SMSは電話番号さえあれば到達可能な通知手段であり、二要素認証コードの送信、緊急アラート、予約リマインダーなど、即時性と確実性が求められる通知シナリオで使用される。Symfony Notifierは、多様なSMSプロバイダを統一的なインターフェースで扱えるようにし、プロバイダの切り替えをアプリケーションコードに影響なく行えるようにする。

**通知の送信タイミング**：アプリケーションコードからNotifier::send()が呼び出され、Notificationのchannelsに"sms"が含まれている場合、またはChannelPolicyでSMSチャネルが選択された場合に送信が実行される。

**通知の受信者**：SmsRecipientInterfaceを実装したRecipientオブジェクトがSMS受信者となる。このインターフェースはgetPhone()メソッドを提供し、受信者の電話番号を返す。SmsChannel::supports()により、RecipientがSmsRecipientInterfaceを実装している場合のみSmsChannelが利用される。

**通知内容の概要**：SMS本文はNotification::getSubject()から取得され、SmsMessageオブジェクトとして送信される。送信元（from）の設定も可能である。

**期待されるアクション**：受信者はSMSメッセージを確認し、通知内容に応じた適切なアクション（認証コードの入力、アラートへの対応、リンクのクリックなど）を行うことが期待される。

## 通知種別

SMS

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Transport直接送信）または非同期（Messenger Bus経由） |
| 優先度 | Notificationのimportanceに依存（メッセージ本体には反映されない） |
| リトライ | Notifierコンポーネント自体にはリトライ機構なし。Messenger利用時はMessengerのリトライ機構に依存 |

### 送信先決定ロジック

1. Notifier::send()に渡されたRecipientがSmsRecipientInterfaceを実装しているかをSmsChannel::supports()で判定する（SmsChannel.php 行49-51）
2. 通知オブジェクトがSmsNotificationInterfaceを実装している場合、asSmsMessage()メソッドでカスタムSmsMessageを生成する（SmsChannel.php 行31-33）
3. カスタムメッセージがnullの場合、SmsMessage::fromNotification()によりデフォルトのSmsMessageを生成する（SmsChannel.php 行35）
4. 受信者の電話番号はSmsRecipientInterface::getPhone()から取得される

## 通知テンプレート

### メール通知の場合

該当なし（SMS通知）

### 本文テンプレート

```
{Notification::getSubject()の内容}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | SMSには添付ファイル機能なし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| subject | SMS本文 | Notification::getSubject() | Yes |
| phone | 送信先電話番号 | SmsRecipientInterface::getPhone() | Yes |
| from | 送信元番号/名称 | SmsMessage::getFrom() | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | Notifier::send()の実行 | Notificationのchannelsに"sms"が含まれる、またはChannelPolicyでsmsが選択される | アプリケーションコードから直接呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| RecipientがSmsRecipientInterfaceを実装していない | SmsChannel::supports()がfalseを返し、送信されない |
| 電話番号が空文字 | SmsMessageコンストラクタでInvalidArgumentExceptionがスローされる（SmsMessage.php 行32-34） |
| RecipientがNoRecipientの場合 | Notifier::getChannels()でLogicExceptionがスローされる（Notifier.php 行94-96） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Notifier::send呼び出し] --> B[getChannels: チャネル決定]
    B --> C[SmsChannel::supports チェック]
    C -->|SmsRecipientInterface実装| D[SmsChannel::notify 実行]
    C -->|未実装| E[スキップ]
    D --> F{SmsNotificationInterface?}
    F -->|Yes| G[asSmsMessage でカスタムメッセージ生成]
    F -->|No| H[SmsMessage::fromNotification でデフォルト生成]
    G --> I[Transport名設定]
    H --> I
    I --> J{Bus設定あり?}
    J -->|Yes| K[Messenger Bus経由で非同期送信]
    J -->|No| L[Transport直接送信]
    K --> M[終了]
    L --> M
    E --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | Notifierコンポーネント自体はデータベースを直接参照しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | Notifierコンポーネント自体はデータベースを直接更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| LogicException | TransportもBusも両方nullの場合（AbstractChannel.php 行28-30） | SmsChannelのコンストラクタでTransportまたはBusの少なくとも一方を指定する |
| InvalidArgumentException | 電話番号が空文字の場合（SmsMessage.php 行32-34） | 受信者に有効な電話番号を設定する |
| LogicException | RecipientがNoRecipientの場合にSmsChannelが選択された（Notifier.php 行94-96） | SMSチャネル利用時は必ずRecipientを指定する |
| TransportExceptionInterface | SMS送信時のトランスポートエラー | アプリケーション側でcatchして適切に処理する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Notifierコンポーネント自体にはリトライ機構なし |
| リトライ間隔 | Messenger利用時はMessengerのリトライ設定に依存 |
| リトライ対象エラー | Messenger利用時はMessengerのリトライポリシーに依存 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Notifierコンポーネント自体にはレート制限なし。SMSプロバイダの制限に依存 |
| 1日あたり上限 | 同上 |

### 配信時間帯

Notifierコンポーネント自体に配信時間帯の制限機能はない。アプリケーション側またはSMSプロバイダ側で制御する必要がある。

## セキュリティ考慮事項

- 電話番号は個人情報であるため、ログ出力時にはマスキングを検討すること
- 二要素認証コード等の機密情報を含む場合は、メッセージの有効期限を短く設定すること
- SMSは暗号化されない通信手段であるため、非常に機密性の高い情報の送信には不向き
- 送信元番号のなりすまし防止のため、プロバイダ側でSender ID検証を有効にすること

## 備考

- SmsChannelはAbstractChannelを継承しており、Transport/Busの初期化ロジックは共通化されている
- SmsMessage::fromNotification()ではNotification::getSubject()がSMS本文として使用される
- SmsMessageにはfrom（送信元）とoptions（プロバイダ固有オプション）を設定可能
- 具体的なSMSプロバイダ（Twilio、Vonage、Amazon SNS等）はNotifier Transportとして別途設定する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SMS通知のデータモデルとインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Notification.php | `src/Symfony/Component/Notifier/Notification/Notification.php` | 通知の基本データ構造。SMS通知ではsubjectがメッセージ本文として使用される |
| 1-2 | SmsNotificationInterface.php | `src/Symfony/Component/Notifier/Notification/SmsNotificationInterface.php` | asSmsMessage()メソッドのシグネチャを確認（行22） |
| 1-3 | SmsRecipientInterface.php | `src/Symfony/Component/Notifier/Recipient/SmsRecipientInterface.php` | getPhone()メソッドを提供する受信者インターフェースを確認（行20） |
| 1-4 | SmsMessage.php | `src/Symfony/Component/Notifier/Message/SmsMessage.php` | コンストラクタ（行26-35）でphone, subject, from, optionsを受け取る構造を理解 |

**読解のコツ**: SmsMessage::fromNotification()（行37-43）はシンプルで、recipientのphone番号とnotificationのsubjectのみを使用する。fromやoptionsはカスタムメッセージ生成時にのみ設定される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Notifier.php | `src/Symfony/Component/Notifier/Notifier.php` | send()メソッド（行40-51）。特にNoRecipientの場合のSmsChannel制限（行94-96）に注意 |

**主要処理フロー**:
1. **行40-51**: send()でRecipientごとにgetChannels()を呼び、各チャネルのnotify()を実行
2. **行94-96**: SmsChannelの場合、NoRecipientではLogicExceptionがスローされる

#### Step 3: チャネル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractChannel.php | `src/Symfony/Component/Notifier/Channel/AbstractChannel.php` | Transport/Busの初期化ロジック（行26-34） |
| 3-2 | SmsChannel.php | `src/Symfony/Component/Notifier/Channel/SmsChannel.php` | notify()メソッド（行28-46）でSMS送信処理を理解。supports()（行49-51）でSmsRecipientInterface判定 |

**主要処理フロー**:
- **行31-33**: SmsNotificationInterface実装時はasSmsMessage()でカスタムメッセージ生成
- **行35**: デフォルトはSmsMessage::fromNotification()
- **行37-39**: transportNameが指定されている場合にメッセージに設定
- **行41-45**: Bus==nullの場合はTransport直接送信、それ以外はBus::dispatch()

### プログラム呼び出し階層図

```
Notifier::send()
    |
    +-- getChannels()
    |       +-- Notification::getChannels()
    |       +-- ChannelPolicy::getChannels() [channels未設定時]
    |       +-- NoRecipientチェック [SmsChannel用]
    |
    +-- SmsChannel::supports()
    |       +-- recipient instanceof SmsRecipientInterface
    |
    +-- SmsChannel::notify()
            |
            +-- [SmsNotificationInterface] notification->asSmsMessage()
            |       または
            +-- SmsMessage::fromNotification()
            |       +-- new SmsMessage(phone, subject)
            |
            +-- SmsMessage::transport() [transportName設定]
            |
            +-- [Bus == null] Transport::send(message)
            +-- [Bus != null] Bus::dispatch(message)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Notification                    Notifier::send()
  - subject          -------->    |
  - channels                      v
                               SmsChannel::notify()
SmsRecipientInterface             |
  - phone            -------->    v                    -------->  SMS送信
                               SmsMessage生成                     (Transport or Bus)
AbstractChannel設定               |
  - transport        -------->    v
  - bus                        送信実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Notification.php | `src/Symfony/Component/Notifier/Notification/Notification.php` | ソース | 通知の基本クラス |
| SmsNotificationInterface.php | `src/Symfony/Component/Notifier/Notification/SmsNotificationInterface.php` | ソース | SMS通知インターフェース。asSmsMessage()を定義 |
| SmsChannel.php | `src/Symfony/Component/Notifier/Channel/SmsChannel.php` | ソース | SMS送信チャネル |
| AbstractChannel.php | `src/Symfony/Component/Notifier/Channel/AbstractChannel.php` | ソース | チャネル基底クラス。Transport/Busの初期化 |
| SmsMessage.php | `src/Symfony/Component/Notifier/Message/SmsMessage.php` | ソース | SMSメッセージクラス |
| SmsRecipientInterface.php | `src/Symfony/Component/Notifier/Recipient/SmsRecipientInterface.php` | ソース | SMS受信者インターフェース |
| Notifier.php | `src/Symfony/Component/Notifier/Notifier.php` | ソース | 通知送信のエントリーポイント |
| TransportInterface.php | `src/Symfony/Component/Notifier/Transport/TransportInterface.php` | ソース | トランスポートインターフェース |
