---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-SentMessageEvent（Notifier）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全主張がソースコードに基づいており、特に高優先度のレビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Notifier/Event/SentMessageEvent.php`（全体）
- E-02: `src/Symfony/Component/Notifier/Message/SentMessage.php`（全体）
- E-03: `src/Symfony/Component/Notifier/Transport/AbstractTransport.php`（行67-86）
- E-04: `src/Symfony/Component/Notifier/Chatter.php`（行43-54）
- E-05: `src/Symfony/Component/Notifier/Texter.php`（行43-54）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SentMessageEventはfinalクラス | E-01 行20 | ○ |
| C-02 | Eventを継承 | E-01 行20 | ○ |
| C-03 | コンストラクタでSentMessageを受け取る | E-01 行22-24 | ○ |
| C-04 | getMessage()でSentMessageを返す | E-01 行27-29 | ○ |
| C-05 | SentMessageはoriginal, transport, infoをコンストラクタで受け取る | E-02 行24-29 | ○ |
| C-06 | messageIdはsetMessageId()で後から設定可能 | E-02 行41-43 | ○ |
| C-07 | getInfo()はキー指定で特定情報取得、未指定で全配列返却 | E-02 行56-63 | ○ |
| C-08 | AbstractTransport::send()のdoSend()成功後にディスパッチ | E-03 行83 | ○ |
| C-09 | dispatcher==nullの場合イベントなし | E-03 行69-71 | ○ |
| C-10 | doSend()失敗時はFailedMessageEventがディスパッチされSentMessageEventはディスパッチされない | E-03 行77-81 | ○ |
| C-11 | Chatter/TexterのBus経由パスではSentMessageEventはディスパッチされない | E-04 行49-53, E-05 行49-53 | ○ |
| C-12 | SentMessage::getOriginalMessage()で元のメッセージを取得 | E-02 行32-34 | ○ |
| C-13 | SentMessage::getTransport()でTransport名を取得 | E-02 行36-38 | ○ |
| C-14 | SentMessage::getMessageId()でメッセージIDを取得（nullable） | E-02 行45-47 | ○ |
| C-15 | SentMessageのinfoはコンストラクタでデフォルト空配列 | E-02 行27 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はない

## 5) リスクフラグ（レビュー観点）
- 0: SentMessageEventのデータ構造 - ソースコードと完全に一致
- 0: AbstractTransportのイベントフロー内での位置づけ - ソースコードと一致
- 0: SentMessageのプロパティと操作 - ソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] SentMessageEventのデータ構造記述がソースコードと一致しているか
- [ ] AbstractTransport::send()内でのディスパッチタイミングの記述が正確か
- [ ] Chatter/TexterのBus経由パスでディスパッチされない点の記述が正確か
- [ ] SentMessageのgetInfo()の動作記述が正確か
