---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：11-FailedMessageEvent（Notifier）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Symfony 6.3で追加されたイベント**：CHANGELOGの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Notifier/Event/FailedMessageEvent.php`（行20-37）
- E-02: `src/Symfony/Component/Notifier/Transport/AbstractTransport.php`（行67-86）
- E-03: `src/Symfony/Component/Notifier/Message/MessageInterface.php`（行17-26）
- E-04: `src/Symfony/Component/Notifier/Event/MessageEvent.php`（行20-37）
- E-05: `src/Symfony/Component/Notifier/EventListener/NotificationLoggerListener.php`（行46-51）
- E-06: `src/Symfony/Component/Notifier/Event/SentMessageEvent.php`（関連イベント参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailedMessageEventはfinalクラスでEvent基底クラスを継承 | E-01 | ○ |
| C-02 | MessageInterfaceと\Throwableの2プロパティをコンストラクタで受け取る | E-01 | ○ |
| C-03 | getMessage()とgetError()の2つのgetterを提供 | E-01 | ○ |
| C-04 | AbstractTransport::send()内でdoSend()の例外時にディスパッチ | E-02 | ○ |
| C-05 | EventDispatcherがnullの場合イベントはディスパッチされない | E-02 | ○ |
| C-06 | ディスパッチ後に例外を再スロー | E-02 | ○ |
| C-07 | MessageEventが送信前にディスパッチされる | E-02, E-04 | ○ |
| C-08 | SentMessageEventが成功時にディスパッチされる | E-02 | ○ |
| C-09 | MessageInterfaceは4つのメソッドを定義 | E-03 | ○ |
| C-10 | NotificationLoggerListenerがイベント購読の実装例 | E-05 | ○ |
| C-11 | Mailerコンポーネントにも同名のFailedMessageEventが存在 | E-06 | ○ |
| C-12 | Symfony 6.3で追加されたイベント | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12について：CHANGELOGは確認したが導入バージョンの正確性は未検証
  - 候補：CHANGELOG.md / Symfonyリリースノート / Gitタグ履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベントクラスの構造は単純でコードから完全に読み取れる
- 0: 低リスク - ディスパッチ箇所はAbstractTransport.php内に限定
- 1: 中リスク - バージョン情報の正確性は外部情報が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FailedMessageEventのプロパティとメソッドが正確に記載されているか
- [ ] AbstractTransport::send()内のディスパッチ箇所の行番号が正しいか
- [ ] Symfony 6.3導入の記述が正確か（CHANGELOGで確認）
- [ ] MailerコンポーネントのFailedMessageEventとの違いが正しく記載されているか
