---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-FailedMessageEvent（Mailer）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Mailer/Event/FailedMessageEvent.php`（行20-37）
- E-02: `src/Symfony/Component/Mailer/Transport/AbstractTransport.php`（行89-96）
- E-03: `src/Symfony/Component/Notifier/Event/FailedMessageEvent.php`（行20-37）
- E-04: `src/Symfony/Component/Notifier/Transport/AbstractTransport.php`（行77-78）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailedMessageEvent（Mailer）はfinalクラスでEventを継承 | E-01 | ○ |
| C-02 | RawMessageと\Throwableの2プロパティをコンストラクタで受け取る | E-01 | ○ |
| C-03 | getMessage()でRawMessage、getError()で\Throwableを取得 | E-01 | ○ |
| C-04 | doSend()のcatchブロック内でディスパッチ | E-02 | ○ |
| C-05 | ディスパッチ後にcheckThrottling()を実行 | E-02 | ○ |
| C-06 | その後に例外を再スロー | E-02 | ○ |
| C-07 | EventDispatcher未設定時はイベントをディスパッチしない | E-02 | ○ |
| C-08 | Notifier版はMessageInterface（Notifier）を使用 | E-03 | ○ |
| C-09 | Mailer版はRawMessage（Mime）を使用 | E-01 | ○ |
| C-10 | Notifier版にはcheckThrottling()がない | E-04 | ○ |
| C-11 | 名前空間が異なる別クラスとして存在 | E-01, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベントクラスの構造は単純で、コードから完全に読み取れる
- 0: 低リスク - ディスパッチ箇所はAbstractTransport.php内に限定

## 6) レビュアーチェックリスト（最小）
- [ ] FailedMessageEvent（Mailer）のプロパティとメソッドが正確に記載されているか
- [ ] AbstractTransport::send()内のディスパッチ箇所の行番号が正しいか
- [ ] Notifier版との違い（メッセージ型、checkThrottling有無）が正しく記載されているか
- [ ] checkThrottling()がfinallyブロックでも実行される点が適切に記載されているか
