---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-NotificationEmail

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php`（行25-280）
- E-02: `src/Symfony/Bridge/Twig/Mime/TemplatedEmail.php`（行19-116）
- E-03: `src/Symfony/Component/ErrorHandler/Exception/FlattenException.php`（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NotificationEmailはTemplatedEmailを継承 | E-01 | ○ |
| C-02 | 4つの重要度定数（URGENT, HIGH, MEDIUM, LOW） | E-01 | ○ |
| C-03 | デフォルトthemeは'default' | E-01 | ○ |
| C-04 | contextの7つのデフォルトキーと初期値 | E-01 | ○ |
| C-05 | コンストラクタでCssInlinerExtensionとInkyExtensionの存在チェック | E-01 | ○ |
| C-06 | asPublicEmail()でpublicモードのNotificationEmail生成 | E-01 | ○ |
| C-07 | markAsPublic()でimportanceとfooter_textをnullに設定 | E-01 | ○ |
| C-08 | markdown()でMarkdownExtension存在チェックとmarkdownフラグ設定 | E-01 | ○ |
| C-09 | content()でcontent値とrawフラグを設定 | E-01 | ○ |
| C-10 | action()でaction_textとaction_urlを設定 | E-01 | ○ |
| C-11 | exception()で例外文字列化、DataPart添付、importance=urgent設定 | E-01 | ○ |
| C-12 | exception()で件名未設定時に例外メッセージを件名に設定 | E-01 | ○ |
| C-13 | getTextTemplate()/getHtmlTemplate()でテーマ付きデフォルトパス | E-01 | ○ |
| C-14 | context()で自身のcontextキーと親のcontextキーを振り分け | E-01 | ○ |
| C-15 | getContext()でarray_mergeによるマージ | E-01 | ○ |
| C-16 | getPreparedHeaders()でimportance→priority変換と件名プレフィックス付与 | E-01 | ○ |
| C-17 | determinePriority()のmatch式マッピング | E-01 | ○ |
| C-18 | __serialize()/__unserialize()でcontext, theme, renderedを永続化 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - クラスの全機能がソースコードから完全に読み取れる
- 0: 低リスク - テンプレートパスのデフォルト値は明確
- 0: 低リスク - 重要度マッピングは明確なmatch式で定義

## 6) レビュアーチェックリスト（最小）
- [ ] 4つの重要度定数と対応するpriorityマッピングが正確か
- [ ] contextの7つのデフォルトキーと初期値が正確か
- [ ] exception()メソッドの処理フロー（文字列化→添付→importance設定→件名設定）が正確か
- [ ] context()メソッドのキー振り分けロジックが正確に記載されているか
- [ ] テンプレートパスの形式が正確か
- [ ] asPublicEmail()/markAsPublic()の動作が正確か
