---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ExceptionNotification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全主張がソースコードに基づいており、特に高優先度のレビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Notifier/Notification/Notification.php`（全体、特に行59-62, 140-151, 183-195, 197-214）
- E-02: `src/Symfony/Component/Notifier/EventListener/SendFailedMessageToNotifierListener.php`（行44）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fromThrowable()は静的ファクトリメソッドでnew self()とexception()を呼び出す | E-01 行59-62 | ○ |
| C-02 | exception()で件名を「{クラス短縮名}: {メッセージ}」形式で自動生成 | E-01 行142-144 | ○ |
| C-03 | explode('\\')とarray_pop()でFQCNからクラス名を抽出 | E-01 行142-143 | ○ |
| C-04 | FlattenExceptionクラス存在時にFlattenExceptionを生成・保持 | E-01 行145-147 | ○ |
| C-05 | computeExceptionAsString()でFlattenException有無により分岐 | E-01 行197-214 | ○ |
| C-06 | FlattenException利用時はgetAsString()を使用 | E-01 行199-203 | ○ |
| C-07 | FlattenException未利用時はクラス名+メッセージ+ファイル+行+トレースを手動構築 | E-01 行205-213 | ○ |
| C-08 | デフォルト重要度はIMPORTANCE_HIGH | E-01 行45 | ○ |
| C-09 | getDefaultEmoji()はexceptionAsStringが設定済みの場合のみ絵文字を返す | E-01 行183-195 | ○ |
| C-10 | urgent: 雷雲、high: 雨雲、medium: 曇り時々晴れ、low: 晴れ時々曇り | E-01 行189-193 | ○ |
| C-11 | importanceFromLogLevelName()でPSRログレベルから重要度へ変換 | E-01 行114-120 | ○ |
| C-12 | ログレベル500以上: urgent、400以上: high、それ以外: low | E-01 行117 | ○ |
| C-13 | fromThrowable()の第2引数でchannelsを指定可能 | E-01 行59 | ○ |
| C-14 | exception()はfluent interfaceパターン（$thisを返す） | E-01 行140, 150 | ○ |
| C-15 | SendFailedMessageToNotifierListenerがfromThrowable()を使用する例 | E-02 行44 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はない

## 5) リスクフラグ（レビュー観点）
- 0: fromThrowable()/exception()の処理フロー - ソースコードと完全に一致
- 0: computeExceptionAsString()の分岐ロジック - ソースコードと一致
- 0: デフォルト絵文字のマッピング - ソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] fromThrowable()とexception()の処理フロー記述がソースコードと一致しているか
- [ ] FlattenException有無による分岐の記述が正確か
- [ ] セキュリティ考慮事項（スタックトレースの機密情報）が十分か
