---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 36
  claims_without_evidence: 6
confidence_derived: 0.86
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：36 / 42、根拠なし：6
- 優先レビュー（高）
  1. **パスワードリセット手順**: アプリケーション固有の実装に依存するため、具体的なフローは根拠不足
  2. **エンドユーザー向けTOP画面の構成**: アプリケーション固有の画面構成であり、フレームワーク本体からは特定不可
  3. **推奨ブラウザでの動作確認**: ブラウザ互換性テスト結果の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 84件の業務要件定義
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 57画面の画面一覧
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（Mermaid形式）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応関係
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 68機能の一覧
- E-06: `docs/code-to-docs/画面設計書/1-プロファイラーホーム.md` - プロファイラーホーム画面設計書
- E-07: `docs/code-to-docs/画面設計書/12-Webデバッグツールバー.md` - Webデバッグツールバー画面設計書
- E-08: `docs/code-to-docs/機能設計書/20-Security Core.md` - Security Core機能設計書
- E-09: `docs/code-to-docs/機能設計書/40-Mailer.md` - Mailer機能設計書
- E-10: `docs/code-to-docs/機能設計書/41-Notifier.md` - Notifier機能設計書
- E-11: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` - プロファイラーコントローラーソースコード
- E-12: `docs/code-to-docs/画面設計書/38-例外詳細画面（開発環境）.md` - 例外詳細画面設計書（名称確認）
- E-13: `docs/code-to-docs/画面設計書/39-エラー画面（本番環境）.md` - エラー画面設計書（名称確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Symfony 8.1は68のコンポーネント群で構成される | E-05 | ○ |
| C-02 | 主要業務カテゴリ（HTTPリクエスト処理、セキュリティ管理等8カテゴリ） | E-01 | ○ |
| C-03 | ユーザー種別は4種類（システム管理者、アプリケーション開発者、エンドユーザー、APIクライアント） | E-01 | ○ |
| C-04 | フォームログイン認証はユーザー名・パスワードによる認証方式 | E-01, E-08 | ○ |
| C-05 | CSRF保護がフォームに自動的に埋め込まれる | E-01（業務要件No.17） | ○ |
| C-06 | ログインリンクの有効期限はデフォルト600秒 | E-01（業務要件No.10） | ○ |
| C-07 | Remember Me認証によりセッション終了後も認証状態を永続化 | E-01（業務要件No.11） | ○ |
| C-08 | アクセストークン認証はBearerトークンを使用 | E-01（業務要件No.9） | ○ |
| C-09 | パスワード強度検証にPasswordStrength/NotCompromisedPassword制約を使用 | E-01（業務要件No.20） | ○ |
| C-10 | パスワードリセットの具体的な手順 | **根拠なし** | △ |
| C-11 | Webデバッグツールバーはページ下部に自動表示される | E-07 | ○ |
| C-12 | ツールバーのトグルボタンのアクセスキーはD | E-07 | ○ |
| C-13 | ツールバーは開発環境（debug=true）でのみ表示される | E-07 | ○ |
| C-14 | プロファイラーホームは/_profiler/でアクセス可能 | E-06, E-11 | ○ |
| C-15 | プロファイラーホームは直近10件の検索結果へリダイレクト | E-06, E-11 | ○ |
| C-16 | 通知チャネルはメール、SMS、ブラウザ通知、チャット等に対応 | E-10 | ○ |
| C-17 | 80以上のサードパーティ通知サービスに対応 | E-10 | ○ |
| C-18 | 通知の重要度はurgent/high/medium/lowの4段階 | E-10 | ○ |
| C-19 | メール通知はHTML形式とテキスト形式の2種類 | E-02（画面No.54-57） | ○ |
| C-20 | Mailerは同期送信と非同期送信に対応 | E-09 | ○ |
| C-21 | Mailerの対応サービス（Amazon SES、Mailgun、Postmark、SendGrid等） | E-09 | ○ |
| C-22 | フォームコンポーネントは40種類以上のフォーム型を提供 | E-01（業務要件No.31） | ○ |
| C-23 | バリデーション種別（必須、型、文字列、数値範囲、日付等） | E-01（業務要件No.21-28） | ○ |
| C-24 | フォームレイアウトはdiv/table/Bootstrap/Foundation/Tailwindに対応 | E-02（画面No.43-53） | ○ |
| C-25 | ワークフローは場所（Place）と遷移（Transition）で構成 | E-01（業務要件No.32） | ○ |
| C-26 | ガード条件によるワークフロー遷移のブロック | E-01（業務要件No.34） | ○ |
| C-27 | ファイルアップロードのバリデーション（サイズ、MIMEタイプ等） | E-01（業務要件No.27） | ○ |
| C-28 | プロファイラーパネル一覧（24パネル） | E-02, E-03 | ○ |
| C-29 | ロールベースアクセス制御とVoter投票メカニズム | E-08 | ○ |
| C-30 | ユーザーなりすまし（Impersonate）機能 | E-01（業務要件No.18） | ○ |
| C-31 | コンソールコマンドの例（cache:clear、messenger:consume等） | E-01（業務要件No.61） | ○ |
| C-32 | エンドユーザー向けTOP画面の表示要素の具体的構成 | **根拠なし** | △ |
| C-33 | 推奨ブラウザ（Chrome、Edge、Safari、Firefox最新版） | **根拠なし** | △ |
| C-34 | 開発環境では例外詳細画面（スタックトレース付き）が表示される | E-01（業務要件No.63）, E-12 | ○ |
| C-35 | 本番環境ではシンプルなエラーメッセージのみ表示される | E-01（業務要件No.64）, E-13 | ○ |
| C-36 | Webhookコンポーネントによる送受信と署名検証 | E-01（業務要件No.43） | ○ |
| C-37 | RemoteEventコンポーネントによる外部イベント受信 | E-01（業務要件No.44） | ○ |
| C-38 | プロファイラー設定でテーマ変更が可能 | E-02（画面No.10） | ○ |
| C-39 | PHP情報とXdebug情報の確認が可能 | E-02（画面No.8, 9） | ○ |
| C-40 | パスワードはbcrypt/argon2でハッシュ化される | E-01（業務要件No.19） | ○ |
| C-41 | エラーメッセージと対処法の一覧（8項目） | E-01, E-08 | ○ |
| C-42 | サポートチャネル（公式ドキュメント、Slack、GitHub Issues、StackOverflow） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パスワードリセットの具体的手順は、アプリケーション固有の実装に依存するため、フレームワーク本体のコードからは確定できない
  - 候補：アプリケーション固有の設定ファイル / Security Bundle設定 / カスタムコントローラー実装
- エンドユーザー向けTOP画面の構成は、アプリケーション固有のテンプレートであり、フレームワーク本体には含まれない
  - 候補：アプリケーションのTwigテンプレート / ルーティング設定 / コントローラー実装
- 推奨ブラウザの情報は、フレームワーク公式の互換性テスト結果が確認できなかった
  - 候補：Symfony公式ドキュメント / WebProfilerBundleのブラウザテスト設定 / CI設定
- サポートチャネルURLは一般的に知られているものを記載したが、Symfony 8.1固有の公式情報源は未確認
  - 候補：symfony.com / GitHub repository / CONTRIBUTING.md
- アプリケーション固有のビジネスロジック（申請状態遷移の具体例）はフレームワーク本体からは推定
  - 候補：Workflowコンポーネントのテストケース / ドキュメント
- 業務フローのSTEP構成はフレームワーク機能群から論理的に導出したもので、特定のアプリケーション要件に基づくものではない
  - 候補：各コンポーネントの利用順序 / 公式ドキュメントのチュートリアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロファイラーパネル一覧、認証方式の記述はソースコードと設計書で十分に裏付けられている
- 0: 低リスク - バリデーション種別、フォーム型の記述は業務要件一覧と機能設計書で裏付けられている
- 1: 中リスク - 業務フローのSTEP構成はSymfonyフレームワーク本体の特性に合わせた独自構成であり、一般的な業務アプリケーションの構成とは異なる
- 1: 中リスク - エンドユーザー向けの操作手順はフレームワーク本体ではなくアプリケーション固有の実装に依存する部分が大きい
- 0: 低リスク - メーラー、通知、ワークフローの機能説明は機能設計書と業務要件一覧で十分に裏付けられている
- 1: 中リスク - サポートチャネルのURLは一般的な情報に基づいており、Symfony 8.1固有の最新情報は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードリセット手順がアプリケーションの実際の実装と整合しているか確認
- [ ] エンドユーザー向けTOP画面の記述がアプリケーションの実際の画面構成と整合しているか確認
- [ ] 推奨ブラウザがWebプロファイラーの実際の動作確認結果と整合しているか確認
- [ ] 業務フローのSTEP構成がプロジェクトの実際の開発・運用フローと整合しているか確認
- [ ] サポートチャネルのURLが最新の公式情報と整合しているか確認
- [ ] コンソールコマンドの例がSymfony 8.1の実際のコマンド体系と整合しているか確認
- [ ] エラーメッセージと対処法が実際に発生しうるエラーをカバーしているか確認
