# Symfony 8.1 フレームワーク 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】案内・通知機能（通知の配信・受信）](#4-step1案内通知機能通知の配信受信)
5. [【STEP2-3】依頼・届出機能（申請の入力・提出）](#5-step2-3依頼届出機能申請の入力提出)
6. [【STEP3-4】ファイル共有機能（書類のやり取り）](#6-step3-4ファイル共有機能書類のやり取り)
7. [【STEP4-5】管理・処理完了（管理者向け）](#7-step4-5管理処理完了管理者向け)

**【サポート機能】**
8. [FAQ機能](#8-faq機能)
9. [お問合せ機能](#9-お問合せ機能)
10. [マイページ機能](#10-マイページ機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Symfony 8.1 フレームワークとは

Symfony 8.1 は、PHP向けのフルスタックWebアプリケーションフレームワークです。68のコンポーネント群で構成されており、HTTPリクエスト処理、セキュリティ（認証・認可）、フォーム処理、テンプレートレンダリング、メール送信、通知配信、ワークフロー管理、デバッグ・プロファイリングなど、Webアプリケーション開発に必要な機能を包括的に提供します。

本マニュアルでは、Symfonyフレームワークを利用してWebアプリケーションを開発・運用する開発者が、日常的に使用する機能について、業務フローに沿った操作手順を説明します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **HTTPリクエスト処理** | リクエスト・レスポンス処理、ルーティング、セッション管理、HTTP通信 |
| **セキュリティ管理** | フォームログイン認証、アクセストークン認証、CSRF保護、ロールベースアクセス制御 |
| **フォーム・バリデーション** | フォーム作成・レンダリング、データバリデーション、入力値検証 |
| **通知・メール配信** | メール送信、マルチチャネル通知（メール・SMS・チャット）、Webhook送受信 |
| **ワークフロー管理** | 状態遷移定義・実行、ガード条件評価、ワークフローイベント通知 |
| **デバッグ・プロファイリング** | Webプロファイラー、デバッグツールバー、パフォーマンス計測、変数ダンプ |
| **メッセージング** | メッセージバスによる同期・非同期メッセージ処理、タスクスケジューリング |
| **データ処理** | オブジェクトシリアライズ、JSONストリーム処理、プロパティアクセス |

### 1.3 業務フロー概要

Symfonyフレームワークを利用したWebアプリケーション開発・運用の業務は、以下の流れで進行します：

```
+-----------------------------------------------------------------+
|                        業務フロー                                |
+-----------------------------------------------------------------+
|                                                                  |
|  【STEP 1】環境構築とセキュリティ設定                             |
|      管理者がアプリケーション基盤を構築し、認証・認可を設定する      |
|      ↓                                                           |
|  【STEP 2】画面・フォーム・テンプレートの開発                      |
|      開発者がルーティング、コントローラー、テンプレートを作成する     |
|      ↓                                                           |
|  【STEP 3】通知・メール・メッセージングの実装                      |
|      開発者がメール送信、通知配信、ワークフローを設定する            |
|      ↓                                                           |
|  【STEP 4】デバッグ・テスト・プロファイリング                      |
|      開発者がWebプロファイラーとデバッグツールで動作を確認・最適化する |
|      ↓                                                           |
|  【STEP 5】本番環境への展開と運用管理                              |
|      管理者がアプリケーションをデプロイし、継続的に運用管理する       |
|                                                                  |
+-----------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **システム管理者** | 環境構築、セキュリティ設定、CLIコマンド実行、本番環境管理、LDAP/リモート認証設定 |
| **アプリケーション開発者** | HTTPリクエスト処理、ルーティング設定、テンプレート開発、フォーム実装、通知設定、デバッグ・プロファイリング |
| **エンドユーザー** | フォームログイン認証、パスワード管理、各種フォーム入力、通知受信、エラー画面確認 |
| **APIクライアント** | JSON認証、アクセストークン認証、APIリクエスト送受信 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| セキュリティ（認証・認可） | フォームログイン、トークン認証、LDAP認証、ロールベースアクセス制御を提供 | STEP 1 |
| ルーティング | URLパターンに基づくリクエストのコントローラーへの振り分け | STEP 2 |
| フォーム処理 | HTMLフォームの作成、データバリデーション、レンダリング | STEP 2 |
| テンプレートレンダリング | Twigテンプレートエンジンによる画面表示 | STEP 2 |
| メール送信 | SMTP/API経由のメール送信（同期・非同期対応） | STEP 3 |
| マルチチャネル通知 | メール、SMS、Slack、Telegram等80以上のサービスへの通知送信 | STEP 3 |
| ワークフロー管理 | 状態遷移の定義・実行・ガード条件評価 | STEP 3 |
| Webプロファイラー | リクエスト詳細、パフォーマンス、メモリ、ログなどの可視化 | STEP 4 |
| デバッグツールバー | ページ下部に表示されるリアルタイムデバッグ情報 | STEP 4 |
| キャッシュ管理 | PSR-6/PSR-16準拠のキャッシュ保存・取得・削除 | STEP 5 |
| コンソールコマンド | CLIによるアプリケーション管理・運用コマンド実行 | STEP 5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| システム管理者 | アプリケーションの環境構築、設定管理、CLIコマンド実行、LDAP認証・リモートユーザー認証の設定を行う |
| アプリケーション開発者 | フレームワークの各コンポーネントを利用してアプリケーション機能を開発・デバッグする |
| エンドユーザー | Symfonyベースのアプリケーションを通じて業務を行う（フォームログイン、パスワード管理、フォーム入力等） |
| APIクライアント | JSON認証やアクセストークン認証を使用してAPIエンドポイントにアクセスする外部システム・クライアント |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

※ Webデバッグツールバーおよびプロファイラーは上記ブラウザで動作を確認しています。

---

## 2. ログイン・ログアウト手順

Symfony 8.1 は複数の認証方式をサポートしています。アプリケーションの設定に応じて、以下のいずれかの方式でログインします。

### 2.1 フォームログイン認証

1. ブラウザでアプリケーションのログインページにアクセスします
2. ログインフォームが表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| ユーザー名（またはメールアドレス） | 管理者から付与されたユーザー識別子を入力します |
| パスワード | アカウントに設定されたパスワードを入力します |
| 「ログイン状態を保持する」チェックボックス | ブラウザを閉じた後もログイン状態を維持したい場合にチェックします（Remember Me機能） |

3. 「ログイン」ボタンをクリックします
4. 認証に成功すると、アプリケーションのTOP画面（または設定されたリダイレクト先）が表示されます

> **注意**: CSRF保護が有効な場合、ログインフォームにはCSRFトークンが自動的に埋め込まれます。ページを長時間開いたまま放置すると、トークンが無効になりログインに失敗する場合があります。その場合はページを再読み込みしてください。

### 2.2 ログインリンク認証

管理者がログインリンク認証を設定している場合は、以下の手順でログインします。

1. ログインページで「ログインリンクを送信」を選択します
2. 登録済みのメールアドレスを入力し、「送信」ボタンをクリックします
3. 受信したメールに記載されたワンタイムリンクをクリックします
4. リンクの署名ハッシュが検証され、認証が完了します

> **注意**: ログインリンクの有効期限はデフォルトで600秒（10分）です。有効期限を過ぎた場合は、再度リンクの送信をリクエストしてください。

### 2.3 HTTP Basic認証

API向けの基本認証が設定されている場合は、ブラウザのダイアログに従ってユーザー名とパスワードを入力します。

### 2.4 アクセストークン認証（APIクライアント向け）

APIクライアントの場合、HTTPリクエストヘッダーにBearerトークンを含めて認証します。

```
Authorization: Bearer <アクセストークン>
```

### 2.5 ログアウト方法

1. 画面上のユーザーメニューまたはナビゲーションから「ログアウト」を選択します
2. Symfonyのセキュリティシステムがセッションを無効化し、ログイン画面に戻ります

> **注意**: Remember Me機能でログインしている場合、ログアウト時にRemember Meクッキーも自動的に削除されます。

### 2.6 パスワードを忘れた場合

1. ログイン画面で「パスワードを忘れた場合」リンクをクリックします
2. 登録済みのメールアドレスを入力して送信します
3. パスワードリセット用のメール（またはログインリンク）を確認します
4. メール内のリンクから新しいパスワードを設定します

> **注意**: パスワードの強度検証が有効な場合、以下の条件が適用されます：
> - パスワード強度の要件（PasswordStrength制約）を満たすこと
> - 漏洩パスワードデータベースに含まれないこと（NotCompromisedPassword制約）

---

## 3. トップページ（TOP画面）

### 3.1 エンドユーザー向けTOP画面

Symfonyアプリケーションのトップページは、アプリケーション固有のテンプレートで構成されます。ルーティング設定（Routingコンポーネント）により、トップページのURLに対応するコントローラーが呼び出され、Twigテンプレートがレンダリングされます。

**主要な表示要素（一般的な構成）：**
- ナビゲーションメニュー（各機能へのリンク）
- ユーザー情報（ログインユーザー名、ロール等）
- 通知・お知らせ領域
- 主要業務へのショートカット

### 3.2 開発者向けTOP画面（開発環境）

開発環境では、通常のアプリケーション画面に加えて以下のデバッグ要素が表示されます。

**Webデバッグツールバー：**
ページ下部に自動的に表示される固定バーです。以下の情報をリアルタイムで確認できます。

| ツールバー項目 | 表示内容 |
|--------------|---------|
| HTTPステータスコード | 現在のリクエストのレスポンスステータス |
| リクエスト情報 | コントローラー名、ルート名 |
| パフォーマンス | リクエスト処理時間 |
| メモリ使用量 | PHPメモリ使用量 |
| Ajaxリクエスト | 非同期リクエストの一覧 |
| セキュリティ | 認証状態、ユーザー名 |

**操作方法：**
1. ツールバーの各アイコンにマウスをホバーすると、詳細情報がポップアップ表示されます
2. 各アイコンをクリックすると、対応するWebプロファイラーパネルが開きます
3. トグルボタン（アクセスキー: D）でツールバーの表示/非表示を切り替えられます

---

## 4. 【STEP1】案内・通知機能（通知の配信・受信）

> **業務フローでの位置**: 管理者・開発者がアプリケーションのセキュリティ基盤と通知メカニズムを構築し、エンドユーザーへの通知配信の仕組みを整えるステップです。

### 4.1 通知の受信を確認する（エンドユーザー向け）

Symfonyアプリケーションから送信される通知は、設定されたチャネルに応じて受信します。

**通知チャネルの種類：**

| チャネル | 受信方法 |
|---------|---------|
| メール | 登録済みメールアドレスに送信されます |
| SMS | 登録済み電話番号にテキストメッセージが送信されます |
| ブラウザ通知 | アプリケーション画面上にプッシュ通知が表示されます |
| チャット（Slack/Telegram等） | 指定されたチャットチャネルにメッセージが投稿されます |

**メール通知の確認手順：**
1. メールクライアントで受信トレイを確認します
2. Symfonyアプリケーションからの通知メールを開きます
3. メール本文に記載された指示に従って操作を進めます

> **注意**: 通知の重要度（urgent、high、medium、low）に応じて、送信チャネルが自動的に切り替わります。重要度の高い通知は、メールに加えてSMSやチャット等の複数チャネルで配信される場合があります。

### 4.2 通知メールの形式

Symfonyからのメール通知は以下の2種類の形式で送信されます：

- **HTML形式**: デフォルトスタイルまたはZurb 2フレームワーク対応のレイアウトで表示されます
- **テキスト形式**: プレーンテキストで通知内容が表示されます

### 4.3 通知の配信設定（管理者・開発者向け）

**Notifierコンポーネントによる通知設定の手順：**

1. 通知チャネルポリシーを設定します（重要度に応じたチャネル振り分け）
2. トランスポートDSNを環境変数に設定します（例: Slack、Telegram、Twilio等）
3. Notificationオブジェクトを生成し、件名・本文・重要度・チャネルを指定します
4. Notifier::send() で通知を送信します

**対応する外部通知サービス（80以上のサービスに対応）：**
- メール: Amazon SES、Mailgun、Postmark、SendGrid等
- SMS: Twilio、Vonage、Amazon SNS等
- チャット: Slack、Telegram、Discord、Microsoft Teams等

### 4.4 メール送信の設定（管理者・開発者向け）

**Mailerコンポーネントによるメール送信の設定手順：**

1. メール送信トランスポートのDSNを設定します
2. Emailオブジェクトを作成し、宛先・件名・本文を設定します
3. Mailer::send() でメールを送信します

**送信方式の選択：**
- **同期送信**: Messengerバス未設定時。send()呼び出しで即座にメールが送信されます
- **非同期送信**: Messengerバス設定時。メッセージキュー経由でバックグラウンド送信されます

> **注意**: 非同期送信の場合、メール送信はワーカープロセスで処理されます。`messenger:consume` コマンドでワーカーを起動する必要があります。

---

## 5. 【STEP2-3】依頼・届出機能（申請の入力・提出）

> **業務フローでの位置**: 開発者がフォーム、バリデーション、テンプレートを実装し、エンドユーザーが各種フォームから申請・届出を入力・提出するステップです。

### 5.1 フォーム入力の種類

Symfonyのフォームコンポーネントは40種類以上のフォーム型を提供しています：

| カテゴリ | フォーム型 |
|---------|----------|
| テキスト入力 | TextType、TextareaType、EmailType、UrlType |
| 数値入力 | NumberType、IntegerType、MoneyType、PercentType |
| 日付・時刻 | DateType、TimeType、DateTimeType、BirthdayType、WeekType |
| 選択肢 | ChoiceType、EntityType、CountryType、LanguageType、LocaleType、TimezoneType、CurrencyType |
| ファイル | FileType |
| セキュリティ | PasswordType、HiddenType |
| その他 | CheckboxType、RadioType、CollectionType |

### 5.2 フォーム入力の基本的な流れ

1. アプリケーションの該当ページにアクセスします
2. 表示されたフォームに必要事項を入力します
3. 必須項目が未入力の場合、バリデーションエラーが表示されます
4. 添付ファイルがある場合は「ファイルを選択」ボタンからアップロードします
5. 入力内容を確認し、「送信」ボタンをクリックして申請を完了します

### 5.3 バリデーション（入力値検証）

フォーム送信時に以下のバリデーションが自動的に実行されます：

| バリデーション種別 | チェック内容 |
|-----------------|------------|
| 必須チェック | NotBlank、NotNull制約により未入力を検出 |
| 型チェック | Type制約により入力値の型（文字列、数値、真偽値等）を検証 |
| 文字列形式 | Email、Url、Regex制約により形式を検証 |
| 数値範囲 | Range、GreaterThan、LessThan制約により範囲を検証 |
| 日付・時刻 | Date、DateTime、Time制約により有効な日時形式を検証 |
| ファイル | File、Image制約によりMIMEタイプ・サイズを検証 |
| パスワード強度 | PasswordStrength制約、NotCompromisedPassword制約による検証 |
| 一意性 | Unique制約によりデータの一意性を検証 |

**バリデーションエラーが表示された場合：**
1. エラーメッセージの内容を確認します
2. 該当の入力フィールドを修正します
3. 再度「送信」ボタンをクリックします

### 5.4 フォームのレイアウト

アプリケーションの設定により、フォームは以下のいずれかのCSSフレームワークレイアウトで表示されます：

| レイアウト | 説明 |
|----------|------|
| div | 標準のdiv要素ベースレイアウト |
| table | table要素ベースレイアウト |
| Bootstrap 3/4/5 | Bootstrap対応レイアウト（通常・水平配置） |
| Foundation 5/6 | Foundation対応レイアウト |
| Tailwind 2 | Tailwind CSS対応レイアウト |

### 5.5 ワークフローによる申請状態管理

アプリケーションでワークフローが設定されている場合、申請の状態遷移が管理されます。

**ワークフローの基本概念：**
- **場所（Place）**: 申請の状態（例: 下書き、提出済み、審査中、承認済み、差戻し）
- **遷移（Transition）**: ある状態から別の状態への移行（例: 提出、承認、差戻し）
- **ガード条件**: 遷移実行前に評価される条件（例: 必要な権限を持っているか）

**申請の状態遷移例：**
```
下書き → [提出] → 提出済み → [審査開始] → 審査中 → [承認] → 承認済み
                                              ↘ [差戻し] → 差戻し
```

> **注意**: 遷移可否はガード条件によって制御されるため、必要な権限や条件を満たさない場合は操作ボタンが表示されない、またはエラーが表示されます。

---

## 6. 【STEP3-4】ファイル共有機能（書類のやり取り）

> **業務フローでの位置**: エンドユーザーが申請に必要な書類をアップロードし、管理者が確認するステップです。

### 6.1 ファイルのアップロード

Symfonyのフォームコンポーネント（FileType）を通じてファイルをアップロードします。

**操作手順：**
1. フォーム画面の「ファイルを選択」ボタンをクリックします
2. アップロードするファイルを選択します
3. フォームを送信してファイルをアップロードします

**アップロード時のバリデーション：**

| チェック項目 | 説明 |
|------------|------|
| ファイルサイズ | File制約のmaxSizeパラメータで上限が設定されます |
| MIMEタイプ | File制約のmimeTypesパラメータで許可されるファイル形式が制限されます |
| 画像固有チェック | Image制約により、幅・高さ・アスペクト比等が検証されます |
| 動画固有チェック | Video制約により、動画ファイルのフォーマットが検証されます |

### 6.2 ファイルのダウンロード

アプリケーション画面に表示されたファイルリンクをクリックすることで、ファイルをダウンロードできます。Symfonyの BinaryFileResponse により、適切なContent-Typeヘッダーとともにファイルが配信されます。

### 6.3 アセットファイルの管理

CSS、JavaScript、画像等のWebアセットファイルは、Assetコンポーネント（またはAssetMapperコンポーネント）により管理されます。

**AssetMapper の主な機能：**
- ディレクトリ内のアセットファイルの自動マッピング
- バージョン付きファイル名によるキャッシュバスティング
- CDN対応のURL生成

---

## 7. 【STEP4-5】管理・処理完了（管理者向け）

> **業務フローでの位置**: 管理者がエンドユーザーからの申請を確認・処理し、完了通知を送信するステップです。また、開発者がWebプロファイラーを使用してアプリケーションの動作を確認・最適化するステップでもあります。

### 7.1 Webプロファイラーによる管理・監視

Webプロファイラーは、リクエスト実行の詳細情報を表示する開発者向け管理ツールです。

**プロファイラーへのアクセス方法：**
1. ブラウザで `/_profiler/` にアクセスします
2. プロファイラーホーム画面から直近10件のプロファイルデータが表示される検索結果画面へリダイレクトされます
3. Webデバッグツールバーの各アイコンをクリックして、対応するパネルを開くこともできます

**プロファイラーパネルの一覧：**

| パネル | 表示内容 |
|-------|---------|
| リクエスト情報 | HTTPリクエスト/レスポンスの詳細情報（ヘッダー、クエリ、Cookie等） |
| 例外情報 | 例外・エラーの詳細情報とスタックトレース |
| パフォーマンス（時間） | リクエスト処理時間のタイムライン情報 |
| メモリ使用量 | PHPメモリ使用量データ |
| ログ | Monolog経由で記録されたログメッセージ一覧 |
| イベント | ディスパッチされたイベントの一覧 |
| ルーティング | URLマッチング情報とルートマッチング結果 |
| Ajaxリクエスト | Ajaxリクエストの一覧と詳細 |
| フォーム | フォームの構造・データ変換・バリデーション情報 |
| バリデーター | バリデーション制約と結果の一覧 |
| キャッシュ | キャッシュのヒット/ミス統計 |
| 翻訳 | 翻訳メッセージの使用状況 |
| セキュリティ | 認証ユーザー情報、ロール、アクセス決定の結果 |
| Twig | Twigテンプレートのレンダリング情報 |
| HTTPクライアント | HTTPクライアントのリクエスト/レスポンス情報 |
| メーラー | 送信メールの宛先、件名、本文等 |
| 通知 | Notifierの送信情報 |
| Messenger | メッセージバスのディスパッチ情報 |
| シリアライザー | シリアライズ/デシリアライズの処理情報 |
| ワークフロー | 状態遷移の可視化と履歴 |
| 設定 | Symfony設定・環境情報（バージョン、PHP情報等） |
| コマンド | コンソールコマンドの実行情報 |
| Dump | dump()で出力されたデバッグ情報 |

### 7.2 プロファイラーでの検索

**操作手順：**
1. プロファイラー画面上部の検索バーに検索条件を入力します
2. IP、URL、HTTPメソッド、ステータスコード、時間範囲等で絞り込みが可能です
3. 「検索」ボタンをクリックすると、条件に合致するプロファイルトークン一覧が表示されます
4. トークンをクリックすると、そのリクエストの詳細パネルが表示されます

### 7.3 ロールベースアクセス制御の管理

**セキュリティパネルの活用：**

1. Webプロファイラーの「セキュリティ」パネルを開きます
2. 現在のリクエストにおける認証状態を確認します
   - 認証済みユーザー情報（ユーザー名、ロール）
   - ファイアウォール設定
   - アクセス決定（Voter投票結果）
3. 権限の問題がある場合、Voter投票結果を確認して原因を特定します

### 7.4 ユーザーなりすまし機能（管理者向け）

システム管理者は、別のユーザーとして一時的にアプリケーションを操作できます（Impersonate機能）。

**操作手順：**
1. 対象ユーザーのプロフィールページ等で「なりすまし開始」操作を実行します
2. 対象ユーザーとしてアプリケーションを操作できます
3. デバッグツールバーに「なりすまし中」の表示が出ます
4. 元のユーザーに戻るには、「なりすまし終了」操作を実行します

### 7.5 コンソールコマンドによる管理

Symfonyの Consoleコンポーネントにより、コマンドラインからアプリケーションを管理できます。

**主要なコマンドの例：**

| コマンド | 説明 |
|---------|------|
| `php bin/console cache:clear` | アプリケーションキャッシュのクリア |
| `php bin/console messenger:consume` | メッセージワーカーの起動（非同期メール送信等） |
| `php bin/console debug:router` | ルーティング定義の一覧表示 |
| `php bin/console security:hash-password` | パスワードのハッシュ値生成 |

---

## 8. FAQ機能

### 8.1 Webプロファイラーの活用

Webプロファイラーは、アプリケーション動作に関する疑問を解決するための強力なツールです。

**よくある調査方法：**

1. **リクエストの動作確認**: 「リクエスト情報」パネルでHTTPリクエスト/レスポンスの詳細を確認
2. **パフォーマンス問題の調査**: 「パフォーマンス（時間）」パネルでタイムラインを確認し、ボトルネックを特定
3. **セキュリティの確認**: 「セキュリティ」パネルで認証状態とアクセス決定を確認
4. **フォーム問題の調査**: 「フォーム」パネルでフォーム構造とバリデーション結果を確認
5. **メール送信の確認**: 「メーラー」パネルで送信メールの宛先・件名・本文を確認

### 8.2 エラーページの見方

**開発環境のエラー画面：**
例外が発生した場合、開発環境では例外詳細画面が表示されます。以下の情報を確認できます：
- 例外クラス名とメッセージ
- スタックトレース（呼び出し階層）
- リクエスト情報
- ソースコードの該当箇所

**本番環境のエラー画面：**
本番環境ではシンプルなエラーメッセージのみが表示されます。セキュリティのため、詳細情報は隠蔽されます。

---

## 9. お問合せ機能

### 9.1 Webhook連携によるお問合せ

Symfonyの Webhookコンポーネントを活用して、外部サービスとのお問合せ連携が可能です。

**Webhookの送受信：**
1. Webhook URLが設定されたエンドポイントに対してリクエストが送信されます
2. 受信側ではリクエストの署名検証が行われます
3. 検証に成功したWebhookペイロードが処理されます

### 9.2 リモートイベントによる外部連携

RemoteEventコンポーネントを使用して、サードパーティサービスからのイベントを受信・処理できます。

**対応するイベントタイプ：**
- メール配信ステータス通知
- SMS送信結果通知
- チャットメッセージ受信
- 決済処理結果通知

---

## 10. マイページ機能

### 10.1 プロファイラー設定（開発者向け）

Webプロファイラーの表示設定をカスタマイズできます。

**操作手順：**
1. プロファイラー画面で「設定」ボタンをクリックします
2. 設定モーダルが表示されます
3. テーマ設定（ライト/ダーク）を変更できます
4. 設定を保存して閉じます

### 10.2 PHP情報の確認

プロファイラーから現在のPHP環境情報を確認できます。

**操作手順：**
1. プロファイラーの「設定」パネルを開きます
2. 「PHP情報を表示」リンクをクリックします
3. phpinfo()の出力内容が表示されます

### 10.3 Xdebug情報の確認

Xdebugが有効な場合、Xdebugの設定情報を確認できます。

**操作手順：**
1. プロファイラーの「設定」パネルを開きます
2. 「Xdebug情報を表示」リンクをクリックします
3. xdebug_info()の出力内容が表示されます

### 10.4 セキュリティ設定（エンドユーザー向け）

エンドユーザーは以下のセキュリティ関連設定を管理できます：

| 設定項目 | 説明 |
|---------|------|
| パスワード変更 | 現在のパスワードを入力し、新しいパスワードを設定します |
| Remember Me設定 | ログイン状態の保持設定を管理します |

> **注意**: パスワード変更時は、パスワード強度の要件を満たす必要があります。パスワードは bcrypt または argon2 アルゴリズムでハッシュ化されて保存されます。

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
----------------------------------------------------------------------
【STEP 1】環境構築とセキュリティ設定                   → 4章参照
    管理者がアプリケーション基盤を構築し、認証・認可を設定する
    ↓
【STEP 2】画面・フォーム・テンプレートの開発            → 5章参照
    開発者がルーティング、コントローラー、テンプレートを作成する
    ↓
【STEP 3】通知・メール・メッセージングの実装            → 4章・6章参照
    開発者がメール送信、通知配信、ワークフローを設定する
    ↓
【STEP 4】デバッグ・テスト・プロファイリング            → 7章・8章参照
    開発者がWebプロファイラーとデバッグツールで動作を確認・最適化する
    ↓
【STEP 5】本番環境への展開と運用管理                   → 7章参照
    管理者がアプリケーションをデプロイし、継続的に運用管理する
----------------------------------------------------------------------
```

### 11.1 【管理者】STEP1: 環境構築とセキュリティ設定

業務開始時に、アプリケーションの基盤を構築し、セキュリティを設定します。

**操作手順：**
1. アプリケーションの設定ファイルでセキュリティファイアウォールを定義します
2. 認証方式（フォームログイン、トークン認証、LDAP認証等）を選択・設定します
3. ロール階層とアクセス制御ルールを定義します
4. CSRF保護を有効にします
5. パスワードハッシュアルゴリズム（bcrypt/argon2）を設定します

> **注意**: セキュリティ設定の変更後は、`php bin/console cache:clear` でキャッシュをクリアしてください。

### 11.2 【開発者】STEP2: 画面・フォーム・テンプレートの開発

アプリケーションの画面とフォームを開発します。

**操作手順：**
1. ルーティング定義でURLとコントローラーの対応を設定します
2. コントローラーでリクエスト処理ロジックを実装します
3. Twigテンプレートで画面のHTMLを定義します
4. Formコンポーネントでフォーム型を定義します
5. Validatorコンポーネントでバリデーション制約を設定します

### 11.3 【開発者】STEP3: 通知・メール・メッセージングの実装

メール送信や通知配信の仕組みを実装します。

**操作手順：**
1. Mailerコンポーネントでメール送信トランスポートを設定します
2. Notifierコンポーネントでチャネルポリシーを定義します
3. 必要に応じてWorkflowコンポーネントで状態遷移を定義します
4. Messengerコンポーネントで非同期処理を設定します

### 11.4 【開発者】STEP4: デバッグ・テスト・プロファイリング

Webプロファイラーとデバッグツールバーを使用して動作確認を行います。

**操作手順：**
1. 開発環境でアプリケーションにアクセスします
2. ページ下部のWebデバッグツールバーでリクエストの概要を確認します
3. ツールバーのアイコンをクリックしてプロファイラーパネルを開きます
4. パフォーマンスパネルでリクエスト処理時間を確認し、ボトルネックを特定します
5. セキュリティパネルで認証・認可の動作を確認します
6. メーラーパネルで送信メールの内容を確認します
7. ワークフローパネルで状態遷移の動作を確認します
8. dump()関数でデバッグ情報を出力し、Dumpパネルで確認します

### 11.5 【管理者】STEP5: 本番環境への展開と運用管理

アプリケーションを本番環境に展開し、運用管理を行います。

**操作手順：**
1. `php bin/console cache:clear --env=prod` でキャッシュをクリアします
2. 環境変数を本番用に設定します（.envファイルまたはサーバー環境変数）
3. メッセージワーカーを起動します（`php bin/console messenger:consume`）
4. 本番環境ではWebプロファイラーが無効化されていることを確認します
5. エラー画面がエンドユーザー向けのシンプルな表示になっていることを確認します

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
1. ユーザー名とパスワードが正しいか確認してください
2. Caps Lockがオフになっていることを確認してください
3. CSRF保護が有効な場合、ページを再読み込みしてから再度ログインを試みてください
4. アカウントがロックされていないか、管理者に確認してください

**Q: パスワードを変更したい**

A: マイページのパスワード変更機能から変更できます。新しいパスワードは、アプリケーションで設定されたパスワード強度要件を満たす必要があります。

**Q: ログインリンクが無効です**

A: ログインリンクの有効期限はデフォルトで600秒（10分）です。有効期限を過ぎている場合は、再度ログインリンクの送信をリクエストしてください。

### 12.2 フォーム入力に関するQ&A

**Q: フォーム送信時にエラーが表示されます**

A: バリデーションエラーの内容を確認し、以下の点をチェックしてください：
1. 必須項目がすべて入力されているか
2. メールアドレスやURLの形式が正しいか
3. 数値が指定された範囲内であるか
4. ファイルサイズやファイル形式が要件を満たしているか

**Q: CSRF token is invalid というエラーが出ます**

A: CSRFトークンが無効になっています。ページを再読み込みしてからフォームを再送信してください。長時間ページを開いたまま放置するとトークンが期限切れになることがあります。

### 12.3 プロファイラーに関するQ&A

**Q: Webデバッグツールバーが表示されません**

A: 以下を確認してください：
1. 開発環境（debug=true）で実行していること
2. レスポンスがHTMLであること（JSONレスポンス等には表示されません）
3. XMLHttpRequestでないこと
4. WebProfilerBundleが有効であること

**Q: プロファイラーにアクセスすると404エラーが表示されます**

A: プロファイラーが有効な環境（通常は開発環境のみ）で実行していることを確認してください。プロファイラーが無効な場合は 404 エラーが返されます。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| NotFoundHttpException (404) | 指定されたURLに一致するルートが存在しない | ルーティング定義を確認してください。`php bin/console debug:router` でルート一覧を確認できます |
| AccessDeniedException (403) | 現在のユーザーに必要な権限がない | セキュリティ設定のアクセス制御ルールとユーザーのロールを確認してください |
| AuthenticationException (401) | 認証に失敗した | ユーザー名・パスワードの確認、認証プロバイダーの設定を確認してください |
| InvalidCsrfTokenException | CSRFトークンが無効 | ページを再読み込みしてフォームを再送信してください |
| TransportException (Mailer) | メール送信に失敗した | メール送信トランスポートのDSN設定と接続状態を確認してください |
| ConnectionException (Messenger) | メッセージトランスポートへの接続に失敗 | メッセージキュー（AMQP、Redis等）の稼働状態と接続設定を確認してください |
| TransitionBlockedException (Workflow) | ワークフロー遷移がガード条件によりブロックされた | ガード条件の設定と現在のユーザー権限を確認してください |
| LockConflictException | リソースロックの取得に失敗 | 他のプロセスがロックを保持している可能性があります。時間をおいて再試行してください |

### 13.2 よくあるトラブルと解決方法

**トラブル: アプリケーションの動作が遅い**

解決方法：
1. Webプロファイラーの「パフォーマンス（時間）」パネルでタイムラインを確認します
2. 処理時間の長いイベントやコントローラーを特定します
3. 「キャッシュ」パネルでキャッシュヒット率を確認し、キャッシュの活用を検討します
4. `php bin/console cache:clear` でキャッシュをクリアして再生成します

**トラブル: メールが送信されない**

解決方法：
1. プロファイラーの「メーラー」パネルでメール送信のログを確認します
2. メール送信トランスポートのDSN設定が正しいか確認します
3. 非同期送信の場合、メッセージワーカー（`messenger:consume`）が起動しているか確認します
4. プロファイラーの「Messenger」パネルでメッセージのディスパッチ状態を確認します

**トラブル: 通知が届かない**

解決方法：
1. プロファイラーの「通知」パネルで通知送信情報を確認します
2. チャネルポリシーの設定が正しいか確認します
3. トランスポートDSN（Slack、Telegram等）の設定が正しいか確認します
4. 非同期送信の場合、メッセージワーカーの起動状態を確認します

**トラブル: セッションが切れてログアウトされる**

解決方法：
1. セッションの有効期限設定を確認します
2. セッションストレージ（ファイル、Redis、データベース等）の設定を確認します
3. Remember Me機能の設定を確認します

### 13.3 サポートへの連絡方法

Symfony 8.1 フレームワークに関するサポートは、以下のチャネルで受けられます：

| サポートチャネル | URL/連絡先 |
|---------------|-----------|
| Symfony公式ドキュメント | https://symfony.com/doc/current/index.html |
| Symfony Slack | https://symfony.com/slack |
| GitHub Issues | https://github.com/symfony/symfony/issues |
| StackOverflow | https://stackoverflow.com/questions/tagged/symfony |

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-04 | 初版作成 |

---

*本マニュアルは、Symfony 8.1 フレームワークのエンドユーザー向け業務運用マニュアルです。*
*フレームワークの更新により、画面や操作方法が変更される場合があります。*
