---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 36
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：36 / 40、根拠なし：4
- 優先レビュー（高）
  1. **NFT-005 Messengerワーカー負荷テスト**：スループット基準値「1秒あたり100メッセージ」の根拠が環境依存であり明確なコード根拠なし
  2. **NFT-037 DependencyInjectionコンパイルテスト**：「60秒以内」「512MB以下」の合格基準はプロジェクト固有の性能要件がなく推定値
  3. **NFT-038 CacheWarmer起動時間テスト**：「30秒以内」の合格基準はプロジェクト固有の性能要件がなく推定値
  4. **NFT-039 セッション固定化攻撃防止テスト**：セッション再生成のロジックはSymfony Security Listenerレベルで実装されているが、Sessionクラス単体からは直接確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/HttpKernel/HttpCache/HttpCache.php` - HTTPキャッシュ設定（default_ttl, stale_while_revalidate等のオプション定義）
- E-02: `src/Symfony/Component/RateLimiter/Policy/TokenBucketLimiter.php` - TokenBucket方式のレート制限実装
- E-03: `src/Symfony/Component/RateLimiter/Policy/SlidingWindowLimiter.php` - SlidingWindow方式のレート制限実装
- E-04: `src/Symfony/Component/RateLimiter/RateLimiterFactory.php` - RateLimiterのファクトリ（policy設定: token_bucket, fixed_window, sliding_window, no_limit）
- E-05: `src/Symfony/Component/HttpClient/HttpClient.php` - HTTPクライアント（maxHostConnections=6, maxPendingPushes=50パラメータ）
- E-06: `src/Symfony/Component/Messenger/Worker.php` - メッセンジャーワーカー（sleep=1000000デフォルト、rateLimiters、keepalives）
- E-07: `src/Symfony/Component/Cache/Adapter/RedisAdapter.php` - Redis キャッシュアダプタ
- E-08: `src/Symfony/Component/Lock/Lock.php` - ロック実装（autoRelease, ttl, blocking取得のusleep(100+-10ms)リトライ）
- E-09: `src/Symfony/Component/PasswordHasher/Hasher/NativePasswordHasher.php` - ネイティブパスワードハッシャー（BCrypt cost=13, Argon2対応, sha512プリハッシュ）
- E-10: `src/Symfony/Component/HtmlSanitizer/HtmlSanitizer.php` - HTMLサニタイザー（maxInputLength制限, DoS防止）
- E-11: `src/Symfony/Component/HttpClient/ThrottlingHttpClient.php` - スロットリングHTTPクライアント（RateLimiter連携）
- E-12: `src/Symfony/Component/Messenger/Retry/MultiplierRetryStrategy.php` - 指数バックオフリトライ戦略（maxRetries=3, delayMilliseconds=1000, multiplier=1, jitter=0.1, maxDelayMilliseconds=0）
- E-13: `src/Symfony/Component/HttpClient/RetryableHttpClient.php` - リトライ可能HTTPクライアント（maxRetries=3, GenericRetryStrategy）
- E-14: `src/Symfony/Component/Semaphore/Semaphore.php` - セマフォ実装
- E-15: `src/Symfony/Component/Security/Http/RateLimiter/DefaultLoginRateLimiter.php` - ログインレート制限（globalFactory + localFactory, hash_hmac(sha256)）
- E-16: `src/Symfony/Component/Security/Csrf/CsrfTokenManager.php` - CSRFトークン管理（hash_equals, random_bytes(32), randomize/derandomize）
- E-17: `src/Symfony/Component/PasswordHasher/Hasher/SodiumPasswordHasher.php` - Sodium(Argon2id)パスワードハッシャー（opsLimit, memLimit, sodium_crypto_pwhash_str）
- E-18: `src/Symfony/Component/HttpClient/NoPrivateNetworkHttpClient.php` - SSRF防止HTTPクライアント（IpUtils::PRIVATE_SUBNETS参照）
- E-19: `src/Symfony/Component/HttpFoundation/IpUtils.php` - IPユーティリティ（PRIVATE_SUBNETS定義: 127.0.0.0/8, 10.0.0.0/8等）
- E-20: `src/Symfony/Component/HttpFoundation/Request.php` - HTTPリクエスト（trustedProxies, trustedHosts, HEADER_X_FORWARDED_*定数）
- E-21: `src/Symfony/Component/Security/Core/Authorization/AuthorizationChecker.php` - 認可チェッカー（isGranted, isGrantedForUser, AccessDecisionManager）
- E-22: `src/Symfony/Component/Security/Http/Authenticator/` - 各種Authenticator（FormLogin, HttpBasic, JsonLogin, AccessToken, X509, RemoteUser等）
- E-23: `composer.json` - PHP >=8.4要件、PSR provide定義、依存ライブラリバージョン
- E-24: `src/Symfony/Component/Cache/Adapter/` - 各種キャッシュアダプタ（Redis, Memcached, APCu, Filesystem, PDO, DoctrineDbal等）
- E-25: `src/Symfony/Component/Lock/Store/` - 各種ロックストア（Flock, Redis, Memcached, PostgreSql, DoctrineDbal, Zookeeper, MongoDb, InMemory等）
- E-26: `src/Symfony/Component/HttpKernel/Profiler/Profiler.php` - プロファイラ実装
- E-27: `src/Symfony/Component/Stopwatch/Stopwatch.php` - ストップウォッチ実装
- E-28: `src/Symfony/Component/HttpFoundation/Session/Session.php` - セッション管理
- E-29: `phpunit.xml.dist` - テスト設定（memory_limit=-1, error_reporting=-1, failOnDeprecation=true）
- E-30: `src/Symfony/Component/PasswordHasher/Hasher/CheckPasswordLengthTrait.php` - パスワード長チェックトレイト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: HTTPキャッシュ応答性能テスト - キャッシュヒット時10ms以内 | E-01 | ○ |
| C-02 | NFT-002: TokenBucketLimiter consume()処理1ms以内 | E-02, E-04 | ○ |
| C-03 | NFT-003: SlidingWindowLimiter consume()処理1ms以内 | E-03, E-04 | ○ |
| C-04 | NFT-004: HttpClient 100並列接続 maxHostConnections=6 | E-05 | ○ |
| C-05 | NFT-005: Messengerワーカー 1秒あたり100メッセージ処理 | E-06 | △ |
| C-06 | NFT-006: Redis 1操作あたり平均5ms以内 | E-07 | ○ |
| C-07 | NFT-007: Lock blocking取得 usleep(100+-10ms)リトライ | E-08 | ○ |
| C-08 | NFT-008: BCrypt cost=13 ハッシュ500ms以内 | E-09 | ○ |
| C-09 | NFT-009: HtmlSanitizer maxInputLength制限 DoS防止 | E-10 | ○ |
| C-10 | NFT-010: ThrottlingHttpClient RateLimiter連携 | E-11 | ○ |
| C-11 | NFT-011: MultiplierRetryStrategy 指数バックオフ jitter=0.1 | E-12 | ○ |
| C-12 | NFT-012: RetryableHttpClient maxRetries=3 GenericRetryStrategy | E-13 | ○ |
| C-13 | NFT-013: Lock autoRelease=true __destruct()での自動解放 | E-08 | ○ |
| C-14 | NFT-014: Semaphoreリソース管理 | E-14 | ○ |
| C-15 | NFT-015: RejectRedeliveredMessageException メッセージ拒否 | E-06 | ○ |
| C-16 | NFT-016: ChainAdapter フォールバック | E-24 | ○ |
| C-17 | NFT-017: DefaultLoginRateLimiter globalFactory+localFactory | E-15 | ○ |
| C-18 | NFT-018: CsrfTokenManager hash_equals検証 | E-16 | ○ |
| C-19 | NFT-019: CSRFトークン random_bytes(32)ランダム化 | E-16 | ○ |
| C-20 | NFT-020: CheckPasswordLengthTrait パスワード長制限 | E-09, E-30 | ○ |
| C-21 | NFT-021: BCrypt 72バイト超 sha512プリハッシュ | E-09 | ○ |
| C-22 | NFT-022: SodiumPasswordHasher Argon2id opsLimit/memLimit | E-17 | ○ |
| C-23 | NFT-023: HtmlSanitizer XSS防止 | E-10 | ○ |
| C-24 | NFT-024: NoPrivateNetworkHttpClient PRIVATE_SUBNETS ブロック | E-18, E-19 | ○ |
| C-25 | NFT-025: Request trustedProxies X-Forwarded-*ヘッダ | E-20 | ○ |
| C-26 | NFT-026: AuthorizationChecker isGranted ロールベース認可 | E-21 | ○ |
| C-27 | NFT-027: 各種Authenticator 認証成功/失敗 | E-22 | ○ |
| C-28 | NFT-028: PHP >=8.4互換性 | E-23 | ○ |
| C-29 | NFT-029: PSR準拠（PSR-6, PSR-7, PSR-11, PSR-14, PSR-17/18） | E-23 | ○ |
| C-30 | NFT-030: Doctrine互換性 dbal ^4.3 orm ^3.4 | E-23 | ○ |
| C-31 | NFT-031: Twig互換性 ^3.21 | E-23 | ○ |
| C-32 | NFT-032: マルチキャッシュストレージ互換性 | E-24 | ○ |
| C-33 | NFT-033: マルチロックストレージ互換性 | E-25 | ○ |
| C-34 | NFT-034: Profiler性能データ収集 | E-26 | ○ |
| C-35 | NFT-035: Stopwatch性能計測 | E-27 | ○ |
| C-36 | NFT-036: ErrorHandler例外処理 | **根拠なし** | △ |
| C-37 | NFT-037: DependencyInjectionコンパイル 60秒以内 512MB以下 | **根拠なし** | △ |
| C-38 | NFT-038: CacheWarmer 30秒以内 | **根拠なし** | △ |
| C-39 | NFT-039: セッション固定化攻撃防止 セッションID再生成 | E-28 | ○ |
| C-40 | NFT-040: MultiplierRetryStrategy maxDelayMilliseconds上限 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- NFT-005（C-05）：Messengerワーカーのスループット基準値（1秒あたり100メッセージ）は環境依存の数値であり、コード内に明示的な性能要件定義が存在しない。sleepオプションのデフォルト値（1000000マイクロ秒）はコードから確認できるが、具体的な処理スループットの保証はない。
  - 候補：性能ベンチマーク結果 / SLA定義書 / 運用要件定義書
- NFT-036（C-36）：ErrorHandlerコンポーネントのソースコードを直接確認していない。コンポーネントの存在はディレクトリ構成から確認できるが、具体的なエラーハンドリングの動作仕様をコードレベルで検証していない。
  - 候補：ErrorHandler/ErrorHandler.php / CHANGELOG.md
- NFT-037（C-37）：DependencyInjectionコンパイルの時間・メモリ合格基準は一般的なフレームワーク性能目標に基づく推定値であり、プロジェクト固有の定量的根拠がない。
  - 候補：性能要件定義書 / ベンチマーク結果 / CI/CDパイプライン設定
- NFT-038（C-38）：CacheWarmer処理時間の合格基準（30秒以内）は一般的なデプロイ要件に基づく推定値であり、プロジェクト固有の定量的根拠がない。
  - 候補：デプロイ要件定義書 / 運用マニュアル / CI/CDパイプライン設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - NFT-035（Stopwatch計測）：機能テスト的な側面が強く、非機能要件としての重要度は低い
- 1: 中リスク - NFT-005, NFT-037, NFT-038：性能基準値が環境依存であり、実環境でのベンチマーク結果に基づく調整が必要
- 1: 中リスク - NFT-036：ErrorHandlerの詳細動作検証が不足しており、テスト条件の具体化が必要
- 2: 高リスク - セキュリティ関連テスト（NFT-017〜027）：セキュリティテストの合格基準は攻撃シナリオに依存するため、ペネトレーションテストとの連携が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テスト（NFT-001〜010）の合格基準値が対象環境のハードウェアスペックに合致しているか確認
- [ ] NFT-005のMessengerスループット基準が実運用要件に適合しているか確認
- [ ] NFT-037, NFT-038のコンパイル/ウォームアップ時間基準が実プロジェクトの規模に適合しているか確認
- [ ] セキュリティテスト（NFT-017〜027）がOWASP Top 10等のセキュリティ基準を十分にカバーしているか確認
- [ ] 互換性テスト（NFT-028〜033）の対象バージョン範囲がcomposer.jsonの制約と一致しているか確認
- [ ] 可用性テスト（NFT-011〜016, NFT-040）のリトライ/フォールバックシナリオが実運用の障害パターンを網羅しているか確認
