---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 36
  claims_without_evidence: 6
confidence_derived: 0.86
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：36 / 42、根拠なし：6
- 優先レビュー（高）
  1. **可用性（稼働率・RTO・RPO）**：フレームワークソースコードからは具体的数値を抽出不可
  2. **PSR準拠の網羅性**：provide/implementセクションから推定したが全PSR準拠の検証が不完全
  3. **Schedulerコンポーネントの詳細仕様**：ディレクトリ存在のみ確認、内部ロジック未調査

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json`（ルート）- PHP要件、依存関係、コンポーネント一覧
- E-02: `src/Symfony/Component/HttpClient/HttpClientTrait.php` - タイムアウト設定（timeout, max_duration）
- E-03: `src/Symfony/Component/HttpClient/HttpOptions.php` - HTTPクライアントオプション定義
- E-04: `src/Symfony/Component/HttpClient/RetryableHttpClient.php` - リトライ機構（maxRetries=3）
- E-05: `src/Symfony/Component/HttpClient/Retry/GenericRetryStrategy.php` - リトライ戦略（delayMs=1000, multiplier=2.0, jitter=0.1）
- E-06: `src/Symfony/Component/HttpClient/ThrottlingHttpClient.php` - スロットリング機構
- E-07: `src/Symfony/Component/HttpClient/CachingHttpClient.php` - HTTPキャッシュ（RFC 9111準拠）
- E-08: `src/Symfony/Component/HttpClient/NoPrivateNetworkHttpClient.php` - SSRF保護
- E-09: `src/Symfony/Component/RateLimiter/RateLimiterFactory.php` - レートリミッターポリシー（token_bucket, fixed_window, sliding_window, no_limit）
- E-10: `src/Symfony/Component/RateLimiter/Policy/TokenBucketLimiter.php` - トークンバケット実装
- E-11: `src/Symfony/Component/Messenger/Retry/MultiplierRetryStrategy.php` - Messengerリトライ戦略
- E-12: `src/Symfony/Component/Messenger/Worker.php` - Messengerワーカー
- E-13: `src/Symfony/Component/PasswordHasher/Hasher/NativePasswordHasher.php` - パスワードハッシュ（BCrypt cost=13, Argon2）
- E-14: `src/Symfony/Component/Security/Csrf/CsrfTokenManager.php` - CSRFトークン管理
- E-15: `src/Symfony/Component/Security/Http/RateLimiter/DefaultLoginRateLimiter.php` - ログインスロットリング
- E-16: `src/Symfony/Component/Cache/Adapter/` - キャッシュアダプター一覧（15種類以上）
- E-17: `src/Symfony/Component/Lock/Store/` - ロックストア一覧（10種類）
- E-18: `src/Symfony/Component/ErrorHandler/ErrorHandler.php` - エラーハンドラー
- E-19: `src/Symfony/Component/Stopwatch/Stopwatch.php` - パフォーマンスプロファイリング
- E-20: `phpunit.xml.dist` - テスト設定
- E-21: `psalm.xml` - 静的解析設定
- E-22: `UPGRADE-8.0.md`, `UPGRADE-8.1.md` - アップグレードガイド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPクライアントのデフォルトタイムアウトはdefault_socket_timeout、上限172,800秒 | E-02 | ○ |
| C-02 | max_connect_durationオプションでHTTP接続時間を制御 | E-03 | ○ |
| C-03 | max_durationオプションで最大処理時間を制御（デフォルト0） | E-02 | ○ |
| C-04 | キャッシュヒューリスティック鮮度TTLは最大86,400秒 | E-07 | ○ |
| C-05 | レートリミッターはtoken_bucket, fixed_window, sliding_window, no_limitの4ポリシー | E-09 | ○ |
| C-06 | TokenBucketLimiterはmaxBurstとrateで制御 | E-10 | ○ |
| C-07 | ThrottlingHttpClientがLimiterInterfaceと連携 | E-06 | ○ |
| C-08 | DefaultLoginRateLimiterはグローバル+ローカルの2段階 | E-15 | ○ |
| C-09 | RetryableHttpClientのデフォルト最大リトライは3回 | E-04 | ○ |
| C-10 | GenericRetryStrategyのデフォルト遅延は1000ms、倍率2.0、ジッター0.1 | E-05 | ○ |
| C-11 | リトライ対象ステータスコードは423,425,429,502,503等 | E-05 | ○ |
| C-12 | MultiplierRetryStrategyのデフォルト最大リトライは3回、遅延1000ms | E-11 | ○ |
| C-13 | Retry-Afterヘッダー対応済み | E-04 | ○ |
| C-14 | キャッシュアダプターは15種類以上 | E-16 | ○ |
| C-15 | HTTPレスポンスキャッシュはRFC 9111準拠 | E-07 | ○ |
| C-16 | キャッシュ可能ステータスコードは200,203,204,300,301,404,410 | E-07 | ○ |
| C-17 | stale-if-error対応済み | E-07 | ○ |
| C-18 | must-revalidate対応済み（504返却） | E-07 | ○ |
| C-19 | 稼働率はフレームワーク依存ではない | **根拠なし** | △ |
| C-20 | RTO/RPOはフレームワーク依存ではない | **根拠なし** | △ |
| C-21 | ロックストアは10種類のバックエンド対応 | E-17 | ○ |
| C-22 | CombinedStoreによる冗長構成が可能 | E-17 | ○ |
| C-23 | NativePasswordHasherはBCrypt（cost=13）とArgon2i/2idに対応 | E-13 | ○ |
| C-24 | SensitiveParameterアトリビュートで機密値を隠蔽 | E-13, E-03 | ○ |
| C-25 | CSRFトークンは32バイトランダムキーでXORランダム化 | E-14 | ○ |
| C-26 | hash_equals()によるタイミングセーフ比較 | E-14 | ○ |
| C-27 | NoPrivateNetworkHttpClientがプライベートIPをブロック | E-08 | ○ |
| C-28 | リダイレクト時のクロスオリジンAuth/Cookie送信抑制 | E-08 | ○ |
| C-29 | DNSリバインディング緩和のためDNSキャッシュ | E-08 | ○ |
| C-30 | ログインレートリミットはHMAC-SHA256でハッシュ | E-15 | ○ |
| C-31 | 55以上のコンポーネントが個別パッケージとして利用可能 | E-01 | ○ |
| C-32 | PSR-4,6,16,3,7,18,11,14,13,20に対応 | E-01 | ○ |
| C-33 | デコレーターパターンによる透過的機能追加 | E-04, E-06, E-07, E-08 | ○ |
| C-34 | PHP 8.4以上が必要 | E-01 | ○ |
| C-35 | Psalm・PHPUnitによるコード品質検証 | E-20, E-21 | ○ |
| C-36 | ErrorHandlerの5つのビットフィールド制御 | E-18 | ○ |
| C-37 | UPGRADE-8.0.md/8.1.mdによるマイグレーションガイド | E-22 | ○ |
| C-38 | PSR-3ロギング・Monolog Bridge統合 | E-01 | ○ |
| C-39 | RetryableHttpClientがリトライ情報をログ出力 | E-04 | ○ |
| C-40 | Stopwatchコンポーネントのマイクロ秒精度オプション | E-19 | ○ |
| C-41 | Schedulerコンポーネントの存在 | **根拠なし** | △ |
| C-42 | Messengerワーカーのレートリミット・キープアライブ対応 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- **可用性の具体的数値（C-19, C-20）**: Symfonyはフレームワークライブラリであり、稼働率やRTO/RPOの数値はソースコードに定義されていない。これはフレームワークの性質上妥当であるが、アプリケーション側での定義が必要
  - 候補：デプロイ先インフラ設計書 / 運用設計書 / SLA定義書
- **Schedulerコンポーネント詳細（C-41）**: `src/Symfony/Component/Scheduler/`ディレクトリの存在は確認したが、内部の詳細仕様は未調査
  - 候補：`src/Symfony/Component/Scheduler/`内のソースコード / CHANGELOG.md
- **PSR準拠の完全検証**: `composer.json`のprovideセクションから主要PSR対応を確認したが、各PSRの全要件を満たしているかの個別検証は未実施
  - 候補：各PSRインターフェース実装の単体テスト / PSR適合テストスイート
- **Cron式対応の実装詳細**: `dragonmantank/cron-expression`はdev依存として記載されているが、Schedulerコンポーネント内での統合方法は未調査
  - 候補：`src/Symfony/Component/Scheduler/` / FrameworkBundle設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 性能要件のデフォルト値記載（ソースコードから直接読み取れる数値）
- 0: 低リスク - セキュリティ機構の記載（CSRFトークン、パスワードハッシュ等）
- 1: 中リスク - 可用性要件を「フレームワーク依存ではない」と判断した点（アプリケーション設計者への影響）
- 1: 中リスク - PSR準拠の網羅性（provideセクションからの推定）
- 0: 低リスク - キャッシュ設定の記載（RFC 9111準拠のソースコード内コメントに基づく）
- 1: 中リスク - Schedulerコンポーネントの記載が浅い（ディレクトリ存在のみの確認）

## 6) レビュアーチェックリスト（最小）
- [ ] リトライ設定のデフォルト値がソースコードと一致しているか確認
- [ ] キャッシュ可能ステータスコードがRFC 9111と整合しているか確認
- [ ] パスワードハッシュのデフォルトパラメータ（cost=13, opsLimit=4, memLimit=64MB）が適切か確認
- [ ] 可用性要件について、アプリケーション固有の要件を別途定義する必要があるか確認
- [ ] Schedulerコンポーネントの詳細仕様を必要に応じて追加調査
- [ ] レートリミッターのポリシー選択指針がアプリケーション要件に合致しているか確認
- [ ] TLS検証オプション（verify_peer/verify_host）のデフォルト値を確認
