# 非機能要件定義書

## 概要

本ドキュメントは、Symfony 8.1フレームワーク（PHP >= 8.4対応）のソースコードから抽出した非機能要件を定義するものである。Symfony 8.1はフルスタックPHPフレームワークであり、55以上の独立コンポーネントから構成されている。本書では、フレームワークが提供する性能、可用性、セキュリティ、拡張性、保守性、運用・監視に関する機構とその設計要件を記載する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| HTTPクライアント応答タイムアウト | デフォルト: `default_socket_timeout`（php.ini）、上限172,800秒（2日） | `HttpClientTrait`にて設定。`timeout`オプションで個別に変更可能 |
| HTTPクライアント最大接続時間 | `max_connect_duration`オプションで設定 | `HttpOptions::setMaxConnectDuration()`で指定 |
| HTTPクライアント最大処理時間 | `max_duration`オプションで設定（デフォルト: 0 = 無制限） | リクエスト単位で指定可能 |
| キャッシュヒューリスティック鮮度TTL | 最大86,400秒（24時間） | `CachingHttpClient::MAX_HEURISTIC_FRESHNESS_TTL`で定義 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| レートリミッター（トークンバケット） | `maxBurst`トークン/`rate`間隔で設定 | `TokenBucketLimiter`による制御。最大バースト数と補充レートで制御 |
| レートリミッター（固定ウィンドウ） | `limit`回/`interval`期間 | `FixedWindowLimiter`による制御 |
| レートリミッター（スライディングウィンドウ） | `limit`回/`interval`期間 | `SlidingWindowLimiter`による制御。より精密なウィンドウ制御 |
| HTTPクライアントスロットリング | RateLimiterと連携して制御 | `ThrottlingHttpClient`が`LimiterInterface`を利用してリクエスト数を制限 |
| ログインレートリミット | グローバル（IP別）+ ローカル（ユーザー名+IP別）の2段階 | `DefaultLoginRateLimiter`によるブルートフォース攻撃防止 |

### リトライ設定

| 項目 | デフォルト値 | 備考 |
| --- | --- | --- |
| HTTPクライアントリトライ最大回数 | 3回 | `RetryableHttpClient`の`maxRetries`パラメータ |
| HTTPクライアントリトライ初期遅延 | 1,000ms | `GenericRetryStrategy`の`delayMs` |
| HTTPクライアントリトライ遅延倍率 | 2.0 | `GenericRetryStrategy`の`multiplier`（指数バックオフ） |
| HTTPクライアントリトライ最大遅延 | 0（無制限） | `GenericRetryStrategy`の`maxDelayMs` |
| HTTPクライアントリトライジッター | 0.1（10%） | `GenericRetryStrategy`の`jitter` |
| HTTPクライアントリトライ対象ステータスコード | 423, 425, 429, 502, 503 + 冪等メソッドに限り 0, 500, 504, 507, 510 | `GenericRetryStrategy::DEFAULT_RETRY_STATUS_CODES` |
| Messengerリトライ最大回数 | 3回 | `MultiplierRetryStrategy`の`maxRetries` |
| Messengerリトライ初期遅延 | 1,000ms | `MultiplierRetryStrategy`の`delayMilliseconds` |
| Messengerリトライ遅延倍率 | 1.0（固定遅延） | `MultiplierRetryStrategy`の`multiplier` |
| Messengerリトライ最大遅延 | 0（無制限） | `MultiplierRetryStrategy`の`maxDelayMilliseconds` |
| Messengerリトライジッター | 0.1（10%） | `MultiplierRetryStrategy`の`jitter` |
| Retry-Afterヘッダー対応 | 対応済み | `RetryableHttpClient::getDelayFromHeader()`で数値（秒）およびHTTP日付形式を解析 |

### キャッシュ設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 対応キャッシュアダプター | APCu, Redis, Memcached, Filesystem, PDO, DoctrineDbal, PhpArray, PhpFiles, Array, Null等 | `Cache\Adapter`名前空間に各実装 |
| タグ対応キャッシュ | Redis, Filesystem, 汎用TagAwareAdapter | `TagAwareAdapterInterface`を実装 |
| チェインキャッシュ | 複数アダプターのカスケード | `ChainAdapter`で多段キャッシュ構成が可能 |
| HTTPレスポンスキャッシュ | RFC 9111準拠 | `CachingHttpClient`による。Cache-Control, ETag, Last-Modified, Expires対応 |
| キャッシュ可能ステータスコード | 200, 203, 204, 300, 301, 404, 410 | `CachingHttpClient::CACHEABLE_STATUS_CODES` |
| 条件付きキャッシュ可能ステータスコード | 302, 303, 307, 308 | 明示的なキャッシュディレクティブが必要 |
| キャッシュ可能HTTPメソッド | GET, HEAD | `CachingHttpClient::CACHEABLE_METHODS` |
| キャッシュ無効化トリガーメソッド | POST, PUT, DELETE, PATCH | `CachingHttpClient::UNSAFE_METHODS` |
| stale-if-error対応 | 対応済み | サーバーエラー時またはネットワークエラー時にステールキャッシュを返却 |
| must-revalidate対応 | 対応済み | 再検証失敗時に504 Gateway Timeoutを返却 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | フレームワーク依存ではなくアプリケーション側で設計 | Symfonyはライブラリであり、稼働率はデプロイ先インフラに依存 |
| 計画停止時間 | フレームワーク依存ではなくアプリケーション側で設計 | 同上 |
| 障害復旧時間（RTO） | フレームワーク依存ではなくアプリケーション側で設計 | 同上 |
| 目標復旧時点（RPO） | フレームワーク依存ではなくアプリケーション側で設計 | 同上 |
| リトライによる自動復旧（HTTP） | 最大3回の自動リトライ + 指数バックオフ | `RetryableHttpClient`が透過的にリトライ |
| リトライによる自動復旧（Messenger） | 最大3回の自動リトライ + 設定可能なバックオフ | `MultiplierRetryStrategy`による非同期メッセージ再処理 |
| ステールキャッシュフォールバック | サーバーエラー時にステールキャッシュを返却 | `CachingHttpClient`の`StaleButUsable`フレッシュネス判定 |
| 分散ロック | Redis, Memcached, PostgreSQL, DoctrineDBAL, MongoDB, Zookeeper, Semaphore, Flock | `Lock\Store`名前空間に各実装。競合状態の防止 |
| 複合ロックストア | 複数ストアの組み合わせ | `CombinedStore`による冗長構成 |
| 非同期メッセージ処理 | Messenger Workerによるキュー消費 | `Worker`クラスがレートリミット、キープアライブ、障害イベントに対応 |

## セキュリティ要件

### 認証・認可

- **パスワードハッシュ**: `NativePasswordHasher`がBCrypt（デフォルトcost: 13）およびArgon2i/Argon2id（opsLimit: 4, memLimit: 64MB）に対応。`password_hash()`/`password_verify()`のネイティブPHP関数を使用。BCryptの72バイト制限はSHA-512プリハッシュで対応
- **パスワード長制限**: `CheckPasswordLengthTrait`による最大パスワード長チェック（過度に長いパスワードによるDoS防止）
- **リハッシュ検出**: `needsRehash()`メソッドによるハッシュアルゴリズム/パラメータ変更時の自動再ハッシュ
- **機密パラメータ保護**: `#[\SensitiveParameter]`アトリビュートによるスタックトレースからの機密値隠蔽

### CSRF保護

- **CSRFトークン管理**: `CsrfTokenManager`によるトークン生成・検証。セッションベースストレージ（`NativeSessionTokenStorage`）
- **トークンランダマイゼーション**: 32バイトのランダムキーによるXOR演算でトークンをランダム化し、BREACH攻撃を緩和
- **タイミング安全比較**: `hash_equals()`によるタイミングセーフなトークン比較
- **名前空間分離**: HTTPS/HTTP別の名前空間でトークンを分離

### SSRF保護

- **プライベートネットワークブロック**: `NoPrivateNetworkHttpClient`がプライベートIPアドレスへのリクエストをブロック。DNS解決後のIP検証を含む
- **リダイレクト時のIP検証**: リダイレクト先URLについてもプライベートネットワーク検証を実施
- **DNSキャッシュ**: DNSリバインディング攻撃の緩和のためDNS解決結果をキャッシュ
- **認証ヘッダーの保護**: リダイレクト時にクロスオリジンへのAuthorization/Cookieヘッダーの送信を抑制

### ログインスロットリング

- **2段階レートリミット**: IP別（グローバル）およびユーザー名+IP別（ローカル）のレートリミット。幅優先攻撃に対応
- **秘密キーによるハッシュ**: HMAC-SHA256でIP/ユーザー名をハッシュ化し、レートリミットキーの推測を防止

### 入力検証・サニタイズ

- **バリデーションフレームワーク**: `Validator`コンポーネントによるアノテーション/アトリビュートベースの入力検証
- **HTMLサニタイズ**: `HtmlSanitizer`コンポーネントによるXSS防止
- **TLS検証**: HTTPクライアントの`verify_peer`/`verify_host`オプション、CA証明書設定、クライアント証明書対応、暗号スイート指定、ピアフィンガープリント検証

### HTTPリダイレクト制御

- **最大リダイレクト数**: `max_redirects`オプションで制御可能
- **PRG対応**: 301, 302, 303ステータスコードでPOSTをGETに変換

## 拡張性要件

### コンポーネントアーキテクチャ

- **独立コンポーネント設計**: 55以上のコンポーネントが`composer.json`の`replace`セクションで個別パッケージとして利用可能。各コンポーネントは独立してインストール・使用可能
- **PSR準拠**: PSR-4（オートローディング）、PSR-6/PSR-16（キャッシュ）、PSR-3（ロギング）、PSR-7/PSR-18（HTTPメッセージ/クライアント）、PSR-11（コンテナ）、PSR-14（イベントディスパッチャー）、PSR-13（リンク）、PSR-20（クロック）に対応
- **デコレーターパターン**: HTTPクライアントは`DecoratorTrait`/`AsyncDecoratorTrait`による透過的な機能追加（キャッシュ、リトライ、スロットリング、プライベートネットワークブロック、トレース等）が可能
- **ストラテジーパターン**: リトライ戦略（`RetryStrategyInterface`）、レートリミットポリシー（`token_bucket`, `fixed_window`, `sliding_window`, `no_limit`）が差し替え可能

### 依存性注入

- **DIコンテナ**: `DependencyInjection`コンポーネントによるサービスの管理。PSR-11準拠
- **コンパイラパス**: コンテナビルド時のカスタマイズポイント

### イベント駆動

- **イベントディスパッチャー**: PSR-14準拠のイベントシステム。Messengerワーカーイベント（`WorkerStarted`, `WorkerRunning`, `WorkerStopped`, `WorkerMessageReceived`, `WorkerMessageHandled`, `WorkerMessageFailed`, `WorkerRateLimited`）等

### ストレージ抽象化

- **キャッシュストレージ**: アダプターパターンによる15種類以上のバックエンド対応
- **ロックストレージ**: 10種類のバックエンド（Redis, Memcached, PostgreSQL, DoctrineDBAL, Flock, InMemory, MongoDB, Semaphore, Zookeeper, Combined）
- **レートリミッターストレージ**: `StorageInterface`による抽象化

## 保守性要件

### PHP要件

- **最小PHPバージョン**: PHP 8.4以上
- **必須PHP拡張**: ext-xml
- **推奨PHP拡張**: ext-redis (>= 6.1), ext-relay (>= 0.12.1), sodium

### コード品質

- **静的解析**: Psalm（`psalm.xml`設定あり）によるコード品質検証
- **テストフレームワーク**: PHPUnit（`phpunit.xml.dist`設定あり）。`symfony/phpunit-bridge`による拡張テスト機能
- **オートローディング**: PSR-4準拠。テスト・binディレクトリはクラスマップから除外
- **エラーハンドリング**: `ErrorHandler`コンポーネントによる構造化されたエラー処理。5つのビットフィールド（thrownErrors, loggedErrors, scopedErrors, tracedErrors, screamedErrors）による細粒度制御

### 後方互換性

- **CHANGELOGファイル**: 各コンポーネントにCHANGELOG.mdを配置
- **UPGRADEガイド**: `UPGRADE-8.0.md`、`UPGRADE-8.1.md`によるマイグレーションガイド
- **セマンティックバージョニング**: `composer/semver`による厳密なバージョン管理

### 非推奨管理

- **Deprecation通知**: `ErrorHandler`がE_DEPRECATED/E_USER_DEPRECATEDレベルをログに記録（例外はスローしない）
- **PHPUnit Bridge**: テスト時の非推奨検出と管理

## 運用・監視要件

### ロギング

- **PSR-3ロギング**: `psr/log`インターフェースに準拠。Monolog Bridge（`monolog/monolog ^3.0`）による統合
- **HTTPクライアントログ**: リトライ時の試行回数・遅延・ステータスコード・エラーメッセージのログ出力（`RetryableHttpClient`）
- **エラーハンドラーログ**: エラーレベル別のPSR-3ロガー割り当て。LogLevel別の制御

### パフォーマンスプロファイリング

- **Stopwatchコンポーネント**: コード実行時間のプロファイリング。マイクロ秒精度オプション（`morePrecision`）対応
- **DataCollector**: `TraceableAdapter`（キャッシュ）、`TraceableHttpClient`（HTTP）、`TraceableMessageBus`（Messenger）によるランタイムメトリクス収集
- **WebProfiler Bundle**: 開発時のリクエスト分析・デバッグUI

### スケジューリング

- **Schedulerコンポーネント**: `symfony/scheduler`による定期実行タスクの管理
- **Cron式対応**: `dragonmantank/cron-expression`（dev依存）によるcron形式のスケジュール定義

### プロセス管理

- **Messenger Worker**: 非同期メッセージ処理ワーカー。停止シグナル対応（`shouldStop`フラグ）、メタデータ追跡（`WorkerMetadata`）
- **Keepalive**: `KeepaliveReceiverInterface`による長時間実行ワーカーの接続維持
- **レートリミット統合**: Workerレベルでのレートリミット（`WorkerRateLimitedEvent`）

## 備考

- 本ドキュメントはSymfony 8.1フレームワークのソースコードから機械的に抽出した非機能要件である。実際のアプリケーションにおける非機能要件は、Symfony上に構築されるアプリケーション固有の設定やインフラストラクチャ構成に大きく依存する
- 可用性（稼働率、RTO、RPO）についてはフレームワークレベルでは定義されておらず、デプロイ環境・運用設計で決定される
- リトライ・キャッシュ・レートリミットの具体的な数値はデフォルト値を記載しており、アプリケーション設定で変更可能である
- セキュリティ関連の暗号アルゴリズムパラメータ（BCrypt cost、Argon2 opsLimit/memLimit等）はアプリケーションの性能・セキュリティバランスに応じて調整が必要である
