# TensorFlow

## 概要

TensorFlowは、Googleが開発したエンドツーエンドのオープンソース機械学習プラットフォームである。データフローグラフを用いて数値計算を表現し、CPU、GPU、TPUなど多様なハードウェア上で大規模な機械学習モデルの学習と推論を実行できる。研究者から開発者まで幅広いユーザーが、深層学習をはじめとする機械学習アプリケーションを構築・デプロイするために利用している。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| モデルの学習・推論 | 深層ニューラルネットワークの学習および推論をサポート。CPU、GPU(CUDA/ROCm)、TPU上で実行可能 |
| TensorFlow Lite | モバイル(Android/iOS)、組み込みデバイス、マイクロコントローラ向けの軽量推論エンジン |
| XLA (Accelerated Linear Algebra) | 線形代数計算を最適化するコンパイラ。学習・推論の高速化に寄与 |
| 分散学習 (tf.distribute) | 複数GPU・複数マシンにまたがる分散学習戦略を提供 |
| DTensor | 分散テンソル抽象化による大規模モデルの並列学習 |
| TensorBoard | 学習メトリクスの可視化、計算グラフの表示、プロファイリングなどを行うツールキット |
| SavedModel / Checkpoint | モデルの保存・復元機能。デプロイやトレーニング再開に使用 |
| tf.data | 効率的なデータパイプライン構築API |
| AutoGraph (tf.autograph) | Pythonコードを自動的にTensorFlowの計算グラフに変換 |
| Keras統合 | 高レベルニューラルネットワークAPIとしてKerasを統合。モデル構築を簡潔に記述可能 |
| マルチ言語API | Python、C++を安定APIとして提供。Java、Go、JavaScript向けAPIも利用可能 |

## 技術スタック

### コア

- フレームワーク: TensorFlow (独自フレームワーク)
- 言語: Python、C++、C
- ビルドシステム: Bazel
- GPUサポート: CUDA (NVIDIA GPU)、ROCm (AMD GPU)
- アクセラレータ: XLA コンパイラ
- モバイル/組み込み: TensorFlow Lite (C++、CMake対応)

### 主要ライブラリ

- absl-py: Google製Pythonユーティリティライブラリ
- numpy: 数値計算ライブラリ
- protobuf: データシリアライゼーション (Protocol Buffers)
- keras: 高レベルニューラルネットワークAPI
- flatbuffers: メモリ効率の良いシリアライゼーション (TFLite向け)
- pybind11: C++/Pythonバインディング
- LLVM/Clang: コンパイラツールチェーン (XLA/MLIR向け)

## ディレクトリ構成

```
tensorflow-master/
├── tensorflow/               # メインソースコード
│   ├── core/                 # TensorFlowのコアランタイム (C++)
│   │   ├── framework/        #   テンソル、オペレーション等の基本フレームワーク
│   │   ├── kernels/          #   オペレーションのカーネル実装
│   │   ├── common_runtime/   #   共通ランタイム (セッション、エグゼキューター等)
│   │   ├── distributed_runtime/ # 分散実行ランタイム
│   │   ├── graph/            #   計算グラフの構築・最適化
│   │   ├── grappler/         #   グラフ最適化エンジン
│   │   ├── ops/              #   オペレーション定義
│   │   └── platform/         #   プラットフォーム抽象化レイヤー
│   ├── python/               # Python API
│   │   ├── eager/            #   Eager Execution
│   │   ├── framework/        #   Pythonフレームワーク層
│   │   ├── keras/            #   Keras統合
│   │   ├── data/             #   tf.data パイプラインAPI
│   │   ├── distribute/       #   分散学習戦略
│   │   ├── compiler/         #   XLAコンパイラ連携
│   │   └── ops/              #   Pythonオペレーションラッパー
│   ├── lite/                 # TensorFlow Lite
│   │   ├── core/             #   Liteコアランタイム
│   │   ├── kernels/          #   Liteカーネル実装
│   │   ├── delegates/        #   ハードウェアデリゲート (GPU, NNAPI等)
│   │   ├── micro/            #   マイクロコントローラ向け
│   │   ├── python/           #   Python API
│   │   ├── java/             #   Java/Android API
│   │   ├── ios/              #   iOS向けビルド設定
│   │   └── tools/            #   ベンチマーク、コンバータ等のツール
│   ├── c/                    # C API
│   ├── cc/                   # C++ API
│   ├── compiler/             # XLA/MLIRコンパイラ
│   ├── distribute/           # 分散学習インフラ
│   ├── dtensor/              # DTensor (分散テンソル)
│   ├── java/                 # Java API
│   ├── go/                   # Go API
│   ├── js/                   # JavaScript API
│   ├── tools/                # 内部ツール
│   └── security/             # セキュリティ関連
├── third_party/              # サードパーティ依存関係
│   ├── xla/                  #   XLAコンパイラ
│   ├── py/                   #   Pythonビルド設定
│   └── ...                   #   その他外部ライブラリ (JPEG, PNG, ICU等)
├── tools/                    # 開発ツール
│   └── tf_env_collect.sh     #   環境情報収集スクリプト
├── ci/                       # CI/CD設定
│   ├── official/             #   公式ビルド設定
│   └── devinfra/             #   開発インフラ設定
├── configure.py              # ビルド設定スクリプト
├── WORKSPACE                 # Bazelワークスペース定義
├── BUILD                     # ルートBUILDファイル
└── requirements_lock_*.txt   # Python依存関係ロックファイル (3.10〜3.13)
```

## セットアップ

### 必要条件

- Python 3.10 / 3.11 / 3.12 / 3.13
- pip (パッケージマネージャー)
- GPU利用時: CUDA対応NVIDIA GPUおよびCUDAツールキット、またはROCm対応AMD GPU

### インストール (pipパッケージ)

GPU対応版 (Ubuntu/Windows):

```
pip install tensorflow
```

CPU専用版:

```
pip install tensorflow-cpu
```

最新版へのアップデート:

```
pip install --upgrade tensorflow
```

Nightlyビルド (テスト用):

```
pip install tf-nightly
```

### ソースからのビルド

1. Bazel (またはBazelisk) をインストール
2. configureスクリプトを実行してビルドオプションを設定:

```
python configure.py
```

configureスクリプトでは以下のオプションを対話的に設定可能:
- Pythonパスおよびライブラリパス
- CUDA / cuDNN サポート (Hermeticバージョン管理対応)
- ROCm サポート
- コンパイラ選択 (Clang / GCC)
- CUDA Compute Capabilities
- Android NDK / SDK パス
- XLA サポート
- 最適化フラグ

3. Bazelでビルド:

```
bazel build //tensorflow/tools/pip_package:wheel
```

## 開発

### ビルドシステム

TensorFlowはBazelをビルドシステムとして使用している。主なビルド設定オプション:

```
--config=opt          # 最適化ビルド
--config=cuda         # CUDA GPUサポート有効
--config=cuda_clang   # CUDAコンパイラとしてClangを使用
--config=rocm         # ROCm GPUサポート有効
--config=mkl          # Intel MKLサポート
--config=mkl_aarch64  # oneDNN + ACL (ARM Architecture) サポート
--config=monolithic   # 静的モノリシックビルド
--config=v1           # TensorFlow 1.x API でビルド
--config=dynamic_kernels  # (実験的) カーネルを個別の共有オブジェクトとしてビルド
```

### テストの実行

```
bazel test //tensorflow/...
```

テストフィルタが自動的に適用される (プラットフォーム依存):
- ベンチマークテスト、OSSで除外すべきテストは自動除外
- GPU未使用環境ではGPUテストが除外
- Windows/macOS固有の除外タグに対応

### コーディング規約

- C++: Google C++ Style Guide に準拠
- Python: 一般的なPythonスタイルガイドに準拠
- 貢献前にContributor License Agreement (CLA) への署名が必要

### 対応プラットフォーム

- Linux (CPU / GPU)
- macOS (CPU)
- Windows (CPU、GPU/CUDAはWSL2経由)
- Android (TensorFlow Lite)
- iOS (TensorFlow Lite)
- Raspberry Pi
- マイクロコントローラ (TensorFlow Lite Micro)
